/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.base.Ticker;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.Queue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.PCEPTerminationReason;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionTest;
import org.opendaylight.protocol.pcep.impl.DefaultPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.protocol.pcep.impl.SslContextFactoryTest;
import org.opendaylight.protocol.pcep.impl.spi.Util;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.util.CheckTestUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.TlsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Starttls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.Uint8;

public class FiniteStateMachineTest
extends AbstractPCEPSessionTest {
    private DefaultPCEPSessionNegotiator serverSession;
    private DefaultPCEPSessionNegotiator tlsSessionNegotiator;

    @Before
    public void setup() {
        Open localPrefs = new OpenBuilder().setKeepalive(Uint8.ONE).build();
        this.serverSession = new DefaultPCEPSessionNegotiator((Promise)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE), this.channel, (PCEPSessionListener)this.listener, 1, 20, localPrefs);
        this.tlsSessionNegotiator = new DefaultPCEPSessionNegotiator((Promise)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE), this.channel, (PCEPSessionListener)this.listener, 1, 20, localPrefs, new TlsBuilder().build());
    }

    @Test
    public void testSessionCharsAccBoth() {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open));
        this.serverSession.handleMessage((Message)this.openMsg);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof Keepalive));
        this.serverSession.handleMessage((Message)this.kaMsg);
        Assert.assertEquals((Object)this.serverSession.getState(), (Object)AbstractPCEPSessionNegotiator.State.FINISHED);
    }

    @Test
    public void testEstablishTLS() {
        DefaultPCEPSessionNegotiator negotiator = new DefaultPCEPSessionNegotiator((Promise)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE), this.channel, (PCEPSessionListener)this.listener, 1, 20, new OpenBuilder().setKeepalive(Uint8.ONE).build(), SslContextFactoryTest.createTlsConfig());
        negotiator.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Starttls));
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.START_TLS_WAIT, (Object)negotiator.getState());
        negotiator.handleMessage((Message)this.startTlsMsg);
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.OPEN_WAIT, (Object)negotiator.getState());
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open));
        negotiator.handleMessage((Message)this.openMsg);
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.KEEP_WAIT, (Object)negotiator.getState());
    }

    @Test
    public void testFailedToEstablishTLS() {
        this.tlsSessionNegotiator.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Starttls));
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.START_TLS_WAIT, (Object)this.tlsSessionNegotiator.getState());
        this.tlsSessionNegotiator.handleMessage((Message)this.startTlsMsg);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof Pcerr));
        Errors obj = (Errors)((Pcerr)this.msgsSend.get(1)).getPcerrMessage().getErrors().get(0);
        Assert.assertEquals((Object)PCEPErrors.NOT_POSSIBLE_WITHOUT_TLS.getErrorType(), (Object)obj.getErrorObject().getType());
        Assert.assertEquals((Object)PCEPErrors.NOT_POSSIBLE_WITHOUT_TLS.getErrorValue(), (Object)obj.getErrorObject().getValue());
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.FINISHED, (Object)this.tlsSessionNegotiator.getState());
    }

    @Test
    public void testTLSUnexpectedMessage() {
        this.tlsSessionNegotiator.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof Starttls));
        Assert.assertEquals((Object)AbstractPCEPSessionNegotiator.State.START_TLS_WAIT, (Object)this.tlsSessionNegotiator.getState());
        this.tlsSessionNegotiator.handleMessage((Message)this.openMsg);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof Pcerr));
        Errors obj = (Errors)((Pcerr)this.msgsSend.get(1)).getPcerrMessage().getErrors().get(0);
        Assert.assertEquals((Object)PCEPErrors.NON_STARTTLS_MSG_RCVD.getErrorType(), (Object)obj.getErrorObject().getType());
        Assert.assertEquals((Object)PCEPErrors.NON_STARTTLS_MSG_RCVD.getErrorValue(), (Object)obj.getErrorObject().getValue());
        Assert.assertEquals((Object)this.tlsSessionNegotiator.getState(), (Object)AbstractPCEPSessionNegotiator.State.FINISHED);
    }

    @Test
    public void testSessionCharsAccMe() {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open));
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open remote = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open)this.msgsSend.get(0);
        this.serverSession.handleMessage((Message)this.openMsg);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(1) instanceof Keepalive));
        this.serverSession.handleMessage((Message)Util.createErrorMessage((PCEPErrors)PCEPErrors.NON_ACC_NEG_SESSION_CHAR, (Open)remote.getOpenMessage().getOpen()));
        Assert.assertEquals((long)3L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(2) instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open));
        this.serverSession.handleMessage((Message)this.kaMsg);
        Assert.assertEquals((Object)this.serverSession.getState(), (Object)AbstractPCEPSessionNegotiator.State.FINISHED);
    }

    @Test
    public void testErrorOneOne() throws Exception {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open));
        this.serverSession.handleMessage((Message)this.kaMsg);
        CheckTestUtil.checkEquals(() -> {
            for (Notification m : this.msgsSend) {
                if (!(m instanceof Pcerr)) continue;
                Errors obj = (Errors)((Pcerr)m).getPcerrMessage().getErrors().get(0);
                Assert.assertEquals((Object)Uint8.ONE, (Object)obj.getErrorObject().getType());
                Assert.assertEquals((Object)Uint8.ONE, (Object)obj.getErrorObject().getValue());
            }
        });
    }

    @Test
    public void testErrorOneSeven() throws Exception {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open));
        this.serverSession.handleMessage((Message)this.openMsg);
        CheckTestUtil.checkEquals(() -> {
            for (Notification m : this.msgsSend) {
                if (!(m instanceof Pcerr)) continue;
                Errors obj = (Errors)((Pcerr)m).getPcerrMessage().getErrors().get(0);
                Assert.assertEquals((Object)Uint8.ONE, (Object)obj.getErrorObject().getType());
                Assert.assertEquals((Object)Uint8.valueOf((int)7), (Object)obj.getErrorObject().getValue());
            }
        });
    }

    @Test
    public void testErrorOneTwo() throws Exception {
        this.serverSession.channelActive(null);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Assert.assertTrue((boolean)(this.msgsSend.get(0) instanceof OpenMessage));
        CheckTestUtil.checkEquals(() -> {
            for (Notification m : this.msgsSend) {
                if (!(m instanceof Pcerr)) continue;
                Errors obj = (Errors)((Pcerr)m).getPcerrMessage().getErrors().get(0);
                Assert.assertEquals((Object)Uint8.ONE, (Object)obj.getErrorObject().getType());
                Assert.assertEquals((Object)Uint8.TWO, (Object)obj.getErrorObject().getValue());
            }
        });
    }

    @Test
    public void testUnknownMessage() {
        Ticker ticker = (Ticker)Mockito.mock(Ticker.class);
        ((Ticker)Mockito.doReturn((Object)0L, (Object[])new Object[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 60000000004L, 60000000005L, 60000000006L, 60000000007L}).when((Object)ticker)).read();
        PCEPSessionListener listener = (PCEPSessionListener)Mockito.mock(PCEPSessionListener.class);
        PCEPSessionImpl session = new PCEPSessionImpl(listener, 5, this.channel, this.openMsg.getOpenMessage().getOpen(), this.openMsg.getOpenMessage().getOpen(), ticker);
        Queue qeue = session.getUnknownMessagesTimes();
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)1L, (long)qeue.size());
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)2L, (long)qeue.size());
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)3L, (long)qeue.size());
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)4L, (long)qeue.size());
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)3L, (long)qeue.size());
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)3L, (long)qeue.size());
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)4L, (long)qeue.size());
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)5L, (long)qeue.size());
        ArgumentCaptor captor = ArgumentCaptor.forClass(PCEPTerminationReason.class);
        ((PCEPSessionListener)Mockito.doNothing().when((Object)listener)).onSessionTerminated((PCEPSession)ArgumentMatchers.eq((Object)session), (PCEPTerminationReason)captor.capture());
        session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        ((Ticker)Mockito.verify((Object)ticker, (VerificationMode)Mockito.times((int)20))).read();
        Assert.assertEquals((Object)"TOO_MANY_UNKNOWN_MSGS", (Object)((PCEPTerminationReason)captor.getValue()).getErrorMessage());
    }
}

