/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationActivator;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationObjectParser;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationTlvParser;
import org.opendaylight.protocol.pcep.parser.BaseParserExtensionActivator;
import org.opendaylight.protocol.pcep.parser.object.PCEPBandwidthObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPClassTypeObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPCloseObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPErrorObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPExcludeRouteObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPExistingBandwidthObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPExplicitRouteObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPGlobalConstraintsObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPIncludeRouteObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPLoadBalancingObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPLspaObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPMetricObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPMonitoringObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPNoPathObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPNotificationObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPObjectiveFunctionObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPOpenObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPOverloadObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPathKeyObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPccIdReqIPv4ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPccIdReqIPv6ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPceIdIPv4ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPPceIdIPv6ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPProcTimeObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPReportedRouteObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPRequestParameterObjectParser;
import org.opendaylight.protocol.pcep.parser.object.PCEPSvecObjectParser;
import org.opendaylight.protocol.pcep.parser.object.bnc.BNCUtil;
import org.opendaylight.protocol.pcep.parser.object.bnc.BranchNodeListObjectParser;
import org.opendaylight.protocol.pcep.parser.object.bnc.NonBranchNodeListObjectParser;
import org.opendaylight.protocol.pcep.parser.object.end.points.PCEPEndPointsIpv4ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.end.points.PCEPEndPointsIpv6ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.end.points.PCEPEndPointsObjectSerializer;
import org.opendaylight.protocol.pcep.parser.object.end.points.PCEPP2MPEndPointsIpv4ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.end.points.PCEPP2MPEndPointsIpv6ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.unreach.PCEPIpv4UnreachDestinationParser;
import org.opendaylight.protocol.pcep.parser.object.unreach.PCEPIpv6UnreachDestinationParser;
import org.opendaylight.protocol.pcep.parser.object.unreach.PCEPUnreachDestinationSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectHeaderImpl;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.pcep.spi.pojo.SimplePCEPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.NoPathVectorTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.BandwidthBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.branch.node.object.BranchNodeListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.object.CCloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.Ipv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.Ipv6CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.P2mpIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.P2mpIpv6CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv4._case.Ipv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.Ipv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case.P2mpIpv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv6._case.P2mpIpv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.XroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.EroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.GcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.IroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.LspaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.MetricBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.MonitoringBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.non.branch.node.object.NonBranchNodeListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.CNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.OfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.OrderBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDurationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.Overload;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.OverloadBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.PathKeyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.path.key.PathKeys;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.path.key.PathKeysBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.NoPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.tlvs.NoPathVectorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTimeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidthBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.RroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.req.missing.tlv.ReqMissingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.RpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.SvecBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.Destination;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv4DestinationCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv4DestinationCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv6DestinationCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv6DestinationCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExcludeRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumberBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

public class PCEPObjectParserTest {
    private TlvRegistry tlvRegistry;
    private VendorInformationTlvRegistry viTlvRegistry;
    private SimplePCEPExtensionProviderContext ctx;
    private BaseParserExtensionActivator act;
    private TestVendorInformationActivator viAct;

    @Before
    public void setUp() {
        this.ctx = new SimplePCEPExtensionProviderContext();
        this.act = new BaseParserExtensionActivator();
        this.viAct = new TestVendorInformationActivator();
        this.act.start((PCEPExtensionProviderContext)this.ctx);
        this.viAct.start((PCEPExtensionProviderContext)this.ctx);
        this.tlvRegistry = this.ctx.getTlvHandlerRegistry();
        this.viTlvRegistry = this.ctx.getVendorInformationTlvRegistry();
    }

    @Test
    public void testOpenObjectWOTLV() throws PCEPDeserializerException, IOException {
        PCEPOpenObjectParser parser = new PCEPOpenObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPOpenObject1.bin"));
        OpenBuilder builder = new OpenBuilder().setProcessingRule(Boolean.valueOf(false)).setIgnore(Boolean.valueOf(false)).setVersion(new ProtocolVersion(Uint8.ONE)).setKeepalive(Uint8.valueOf((int)30)).setDeadTimer(Uint8.valueOf((int)120)).setSessionId(Uint8.ONE);
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.TlvsBuilder().build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCloseObject() throws IOException, PCEPDeserializerException {
        PCEPCloseObjectParser parser = new PCEPCloseObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPCloseObject1.bin"));
        CCloseBuilder builder = new CCloseBuilder().setProcessingRule(Boolean.valueOf(false)).setIgnore(Boolean.valueOf(false)).setReason(Uint8.valueOf((int)5)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.object.c.close.TlvsBuilder().build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testLoadBalancingObject() throws IOException, PCEPDeserializerException {
        PCEPLoadBalancingObjectParser parser = new PCEPLoadBalancingObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPLoadBalancingObject1.bin"));
        LoadBalancingBuilder builder = new LoadBalancingBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(false)).setMaxLsp(Uint8.valueOf((int)241)).setMinBandwidth(new Bandwidth(new byte[]{-1, -1, -1, -1}));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testERObject() throws Exception {
        PCEPExplicitRouteObjectParser parser = new PCEPExplicitRouteObjectParser(this.ctx.getEROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPExplicitRouteObject1PackOfSubobjects.bin"));
        EroBuilder builder = new EroBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject> subs = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject>();
        subs.add(new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)65535))).build()).build()).build());
        subs.add(new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.255/32"))).build()).build()).build());
        subs.add(new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder().setRouterId(Uint32.valueOf((long)0xFFFFFFFFL)).setInterfaceId(Uint32.valueOf((long)0xFFFFFFFFL)).build()).build()).build());
        builder.setSubobject(subs);
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null.", (Object)e.getMessage());
        }
    }

    @Test
    public void testIRObject() throws Exception {
        PCEPIncludeRouteObjectParser parser = new PCEPIncludeRouteObjectParser(this.ctx.getEROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPIncludeRouteObject1PackOfSubobjects.bin"));
        byte[] ip6PrefixBytes = new byte[]{18, 52, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IroBuilder builder = new IroBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList<Subobject> subs = new ArrayList<Subobject>();
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)16))).build()).build()).setLoose(Boolean.valueOf(true)).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("18.52.80.0/21"))).build()).build()).setLoose(Boolean.valueOf(true)).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(Ipv6Util.prefixForBytes((byte[])ip6PrefixBytes, (int)22))).build()).build()).setLoose(Boolean.valueOf(true)).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder().setRouterId(Uint32.valueOf((long)19158648L)).setInterfaceId(Uint32.valueOf((long)2596069104L)).build()).build()).setLoose(Boolean.valueOf(true)).build());
        builder.setSubobject(subs);
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRRObject() throws Exception {
        PCEPReportedRouteObjectParser parser = new PCEPReportedRouteObjectParser(this.ctx.getRROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPReportedRouteObject1PackOfSubobjects.bin"));
        byte[] ip6PrefixBytes = new byte[]{18, 52, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        RroBuilder builder = new RroBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject> subs = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject>();
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder().setSubobjectType((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.IpPrefixCaseBuilder().setIpPrefix(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.255/32"))).build()).build()).setProtectionAvailable(Boolean.valueOf(false)).setProtectionInUse(Boolean.valueOf(false)).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder().setSubobjectType((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.IpPrefixCaseBuilder().setIpPrefix(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder().setIpPrefix(new IpPrefix(Ipv6Util.prefixForBytes((byte[])ip6PrefixBytes, (int)22))).build()).build()).setProtectionAvailable(Boolean.valueOf(false)).setProtectionInUse(Boolean.valueOf(false)).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder().setSubobjectType((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType)new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.UnnumberedCaseBuilder().setUnnumbered(new UnnumberedBuilder().setRouterId(Uint32.valueOf((long)19158648L)).setInterfaceId(Uint32.valueOf((long)2596069104L)).build()).build()).setProtectionAvailable(Boolean.valueOf(false)).setProtectionInUse(Boolean.valueOf(false)).build());
        builder.setSubobject(subs);
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testBandwidthObject() throws IOException, PCEPDeserializerException {
        PCEPBandwidthObjectParser parser = new PCEPBandwidthObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPBandwidthObject1LowerBounds.bin"));
        BandwidthBuilder builder = new BandwidthBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setBandwidth(new Bandwidth(new byte[]{0, 0, 0, 0}));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testExistingBandwidthObject() throws IOException, PCEPDeserializerException {
        PCEPExistingBandwidthObjectParser parser = new PCEPExistingBandwidthObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPBandwidthObject2UpperBounds.bin"));
        ReoptimizationBandwidthBuilder builder = new ReoptimizationBandwidthBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setBandwidth(new Bandwidth(new byte[]{-1, -1, -1, -1}));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEndPointsObjectIPv4() throws IOException, PCEPDeserializerException {
        byte[] srcIPBytes = new byte[]{-94, -11, 17, 14};
        byte[] destIPBytes = new byte[]{-1, -1, -1, -1};
        PCEPEndPointsIpv4ObjectParser parser = new PCEPEndPointsIpv4ObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPEndPointsObject1IPv4.bin"));
        EndpointsObjBuilder builder = new EndpointsObjBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(false)).setAddressFamily((AddressFamily)new Ipv4CaseBuilder().setIpv4(new Ipv4Builder().setSourceIpv4Address(Ipv4Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])srcIPBytes))).setDestinationIpv4Address(Ipv4Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])destIPBytes))).build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        PCEPEndPointsObjectSerializer serializer = new PCEPEndPointsObjectSerializer();
        serializer.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEndPointsObjectP2MPIPv4() throws PCEPDeserializerException {
        byte[] srcIPBytes = new byte[]{-94, -11, 17, 14};
        byte[] destIPBytes = new byte[]{4, 50, 0, 20, 0, 0, 0, 1, -94, -11, 17, 14, -1, -1, -1, -1, -1, -1, -1, -4};
        PCEPP2MPEndPointsIpv4ObjectParser parser = new PCEPP2MPEndPointsIpv4ObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])destIPBytes);
        EndpointsObjBuilder builder = new EndpointsObjBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setAddressFamily((AddressFamily)new P2mpIpv4CaseBuilder().setP2mpIpv4(new P2mpIpv4Builder().setP2mpLeaves(P2mpLeaves.NewLeavesToAdd).setSourceIpv4Address(Ipv4Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])srcIPBytes))).setDestinationIpv4Address((Set)ImmutableSet.of((Object)new Ipv4AddressNoZone("255.255.255.255"), (Object)new Ipv4AddressNoZone("255.255.255.252"))).build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        PCEPEndPointsObjectSerializer serializer = new PCEPEndPointsObjectSerializer();
        serializer.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEndPointsObjectIPv6() throws IOException, PCEPDeserializerException {
        byte[] destIPBytes = new byte[]{0, 2, 93, -46, -1, -20, -95, -74, 88, 30, -97, 80, 0, 0, 0, 0};
        byte[] srcIPBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        PCEPEndPointsIpv6ObjectParser parser = new PCEPEndPointsIpv6ObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPEndPointsObject2IPv6.bin"));
        EndpointsObjBuilder builder = new EndpointsObjBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setAddressFamily((AddressFamily)new Ipv6CaseBuilder().setIpv6(new Ipv6Builder().setSourceIpv6Address(Ipv6Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])srcIPBytes))).setDestinationIpv6Address(Ipv6Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])destIPBytes))).build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        PCEPEndPointsObjectSerializer serializer = new PCEPEndPointsObjectSerializer();
        serializer.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEndPointsObjectP2MPIPv6() throws IOException, PCEPDeserializerException {
        byte[] destIPBytes = new byte[]{4, 66, 0, 56, 0, 0, 0, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 2, 93, -46, -1, -20, -95, -74, 88, 30, -97, 80, 0, 0, 0, 0, 0, 3, 93, -46, -1, -20, -95, -74, 88, 30, -97, 80, 0, 0, 0, 0};
        byte[] srcIPBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        PCEPP2MPEndPointsIpv6ObjectParser parser = new PCEPP2MPEndPointsIpv6ObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])destIPBytes);
        EndpointsObjBuilder builder = new EndpointsObjBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setAddressFamily((AddressFamily)new P2mpIpv6CaseBuilder().setP2mpIpv6(new P2mpIpv6Builder().setP2mpLeaves(P2mpLeaves.NewLeavesToAdd).setSourceIpv6Address(Ipv6Util.addressForByteBuf((ByteBuf)Unpooled.wrappedBuffer((byte[])srcIPBytes))).setDestinationIpv6Address((Set)ImmutableSet.of((Object)new Ipv6AddressNoZone("2:5dd2:ffec:a1b6:581e:9f50::"), (Object)new Ipv6AddressNoZone("3:5dd2:ffec:a1b6:581e:9f50::"))).build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        PCEPEndPointsObjectSerializer serializer = new PCEPEndPointsObjectSerializer();
        serializer.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testErrorObjectWithTlv() throws PCEPDeserializerException, IOException {
        PCEPErrorObjectParser parser = new PCEPErrorObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ErrorObjectBuilder builder = new ErrorObjectBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(true)).setType(Uint8.ONE).setValue(Uint8.ONE);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPErrorObject1.bin"));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPErrorObject3.bin"));
        builder.setType(Uint8.valueOf((int)7)).setValue(Uint8.ZERO).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.error.object.TlvsBuilder().setReqMissing(new ReqMissingBuilder().setRequestId(new RequestId(Uint32.valueOf((long)4437L))).build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testLspaObject() throws IOException, PCEPDeserializerException {
        PCEPLspaObjectParser parser = new PCEPLspaObjectParser(this.tlvRegistry, this.viTlvRegistry);
        LspaBuilder builder = new LspaBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(true)).setExcludeAny(new AttributeFilter(Uint32.ZERO)).setIncludeAny(new AttributeFilter(Uint32.ZERO)).setIncludeAll(new AttributeFilter(Uint32.ZERO)).setHoldPriority(Uint8.ZERO).setSetupPriority(Uint8.ZERO).setLocalProtectionDesired(Boolean.valueOf(false)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.lspa.TlvsBuilder().build());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPLspaObject1LowerBounds.bin"));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPLspaObject2UpperBounds.bin"));
        builder.setExcludeAny(new AttributeFilter(Uint32.MAX_VALUE)).setIncludeAny(new AttributeFilter(Uint32.MAX_VALUE)).setIncludeAll(new AttributeFilter(Uint32.MAX_VALUE)).setHoldPriority(Uint8.MAX_VALUE).setSetupPriority(Uint8.MAX_VALUE).setLocalProtectionDesired(Boolean.valueOf(true));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testMetricObject() throws IOException, PCEPDeserializerException {
        PCEPMetricObjectParser parser = new PCEPMetricObjectParser();
        MetricBuilder builder = new MetricBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(true)).setComputed(Boolean.valueOf(false)).setBound(Boolean.valueOf(false)).setMetricType(Uint8.ONE).setValue(new Float32(new byte[]{0, 0, 0, 0}));
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPMetricObject1LowerBounds.bin"));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPMetricObject2UpperBounds.bin"));
        builder.setComputed(Boolean.valueOf(true)).setBound(Boolean.valueOf(false)).setMetricType(Uint8.TWO).setValue(new Float32(new byte[]{79, 112, 0, 0}));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testNoPathObjectWithTlv() throws PCEPDeserializerException, IOException {
        PCEPNoPathObjectParser parser = new PCEPNoPathObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPNoPathObject1WithoutTLV.bin"));
        NoPathBuilder builder = new NoPathBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(true)).setNatureOfIssue(Uint8.ONE).setUnsatisfiedConstraints(Boolean.valueOf(true)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.TlvsBuilder().build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPNoPathObject2WithTLV.bin"));
        builder.setNatureOfIssue(Uint8.ZERO);
        builder.setUnsatisfiedConstraints(Boolean.valueOf(false));
        NoPathVectorBuilder b = new NoPathVectorBuilder();
        b.setFlags(new NoPathVectorTlv.Flags(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        builder.setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.TlvsBuilder().setNoPathVector(b.build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotifyObjectWithTlv() throws PCEPDeserializerException, IOException {
        PCEPNotificationObjectParser parser = new PCEPNotificationObjectParser(this.tlvRegistry, this.viTlvRegistry);
        CNotificationBuilder builder = new CNotificationBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(true)).setType(Uint8.MAX_VALUE).setValue(Uint8.MAX_VALUE);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPNotificationObject2WithoutTlv.bin"));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPNotificationObject1WithTlv.bin"));
        builder.setType(Uint8.TWO).setValue(Uint8.ONE).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.c.notification.TlvsBuilder().setOverloadDuration(new OverloadDurationBuilder().setDuration(Uint32.valueOf((long)4278190242L)).build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRPObjectWithTlv() throws PCEPDeserializerException, IOException {
        PCEPRequestParameterObjectParser parser = new PCEPRequestParameterObjectParser(this.tlvRegistry, this.viTlvRegistry);
        RpBuilder builder = new RpBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(true)).setReoptimization(Boolean.valueOf(true)).setBiDirectional(Boolean.valueOf(false)).setLoose(Boolean.valueOf(true)).setMakeBeforeBreak(Boolean.valueOf(true)).setOrder(Boolean.valueOf(false)).setPathKey(Boolean.valueOf(false)).setSupplyOf(Boolean.valueOf(false)).setFragmentation(Boolean.valueOf(false)).setP2mp(Boolean.valueOf(false)).setEroCompression(Boolean.valueOf(false)).setPriority(Uint8.valueOf((int)5)).setRequestId(new RequestId(Uint32.valueOf((long)3735928559L))).setTlvs(new TlvsBuilder().build());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPRPObject1.bin"));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPRPObject2.bin"));
        builder.setReoptimization(Boolean.valueOf(false));
        builder.setFragmentation(Boolean.valueOf(true));
        builder.setEroCompression(Boolean.valueOf(true));
        OrderBuilder b = new OrderBuilder().setDelete(Uint32.valueOf((long)0xFFFFFFFFL)).setSetup(Uint32.ONE);
        builder.setTlvs(new TlvsBuilder().setOrder(b.build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSvecObject() throws IOException, PCEPDeserializerException {
        PCEPSvecObjectParser parser = new PCEPSvecObjectParser();
        SvecBuilder builder = new SvecBuilder().setProcessingRule(Boolean.valueOf(false)).setIgnore(Boolean.valueOf(false)).setLinkDiverse(Boolean.valueOf(false)).setNodeDiverse(Boolean.valueOf(false)).setSrlgDiverse(Boolean.valueOf(false)).setPartialPathDiverse(Boolean.valueOf(false)).setLinkDirectionDiverse(Boolean.valueOf(false)).setRequestsIds(Set.of(new RequestId(Uint32.valueOf((int)255))));
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPSvecObject2.bin"));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPSvecObject1_10ReqIDs.bin"));
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setLinkDiverse(Boolean.valueOf(true));
        builder.setSrlgDiverse(Boolean.valueOf(true));
        builder.setRequestsIds((Set)ImmutableSet.of((Object)new RequestId(Uint32.valueOf((long)0xFFFFFFFFL)), (Object)new RequestId(Uint32.valueOf((long)1L)), (Object)new RequestId(Uint32.valueOf((long)19088743L)), (Object)new RequestId(Uint32.valueOf((long)2309737967L)), (Object)new RequestId(Uint32.valueOf((long)4275878552L)), (Object)new RequestId(Uint32.valueOf((long)1985229328L)), (Object[])new RequestId[]{new RequestId(Uint32.valueOf((long)360862310L)), new RequestId(Uint32.valueOf((long)1209142206L)), new RequestId(Uint32.valueOf((long)637238866L)), new RequestId(Uint32.valueOf((long)3002225771L))}));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testClassTypeObject() throws PCEPDeserializerException {
        PCEPClassTypeObjectParser parser = new PCEPClassTypeObjectParser();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])new byte[]{22, 18, 0, 8, 0, 0, 0, 4});
        ClassTypeBuilder builder = new ClassTypeBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(false)).setClassType(new ClassType(Uint8.valueOf((int)4)));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testExcludeRouteObject() throws Exception {
        PCEPExcludeRouteObjectParser parser = new PCEPExcludeRouteObjectParser(this.ctx.getXROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPExcludeRouteObject.1.bin"));
        XroBuilder builder = new XroBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        builder.setFlags(new Xro.Flags(Boolean.valueOf(true)));
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject> subs = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject>();
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.SubobjectBuilder().setMandatory(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("192.168.0.0/16"))).build()).build()).setAttribute(ExcludeRouteSubobjects.Attribute.Node).build());
        subs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.SubobjectBuilder().setMandatory(Boolean.valueOf(false)).setSubobjectType((SubobjectType)new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Uint32.valueOf((long)4660L))).build()).build()).build());
        builder.setSubobject(subs);
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testPathKeyObject() throws Exception {
        PCEPPathKeyObjectParser parser = new PCEPPathKeyObjectParser(this.ctx.getEROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPPathKeyObject.bin"));
        PathKeyBuilder builder = new PathKeyBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList<PathKeys> list = new ArrayList<PathKeys>();
        list.add(new PathKeysBuilder().setLoose(Boolean.valueOf(true)).setPathKey(new PathKey(Uint16.valueOf((int)4660))).setPceId(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId(new byte[]{18, 52, 80, 0})).build());
        builder.setPathKeys(list);
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testObjectiveFunctionObject() throws IOException, PCEPDeserializerException {
        PCEPObjectiveFunctionObjectParser parser = new PCEPObjectiveFunctionObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPObjectiveFunctionObject.1.bin"));
        OfBuilder builder = new OfBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(false)).setCode(new OfId(Uint16.valueOf((int)4))).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.of.TlvsBuilder().build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGlobalConstraintsObject() throws IOException, PCEPDeserializerException {
        PCEPGlobalConstraintsObjectParser parser = new PCEPGlobalConstraintsObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPGlobalConstraintsObject.1.bin"));
        GcBuilder builder = new GcBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(false)).setMaxHop(Uint8.ONE).setMaxUtilization(Uint8.ZERO).setMinUtilization(Uint8.valueOf((int)100)).setOverBookingFactor(Uint8.valueOf((int)99)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.TlvsBuilder().build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testIgnoreUknownObject() throws PCEPDeserializerException {
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object = this.ctx.getObjectHandlerRegistry().parseObject(35, 1, (ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), null);
        Assert.assertNull((Object)object);
    }

    @Test
    public void testUnrecognizedObjectType() throws PCEPDeserializerException {
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object = this.ctx.getObjectHandlerRegistry().parseObject(2, 2, (ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof UnknownObject));
        Assert.assertEquals((Object)PCEPErrors.UNRECOGNIZED_OBJ_TYPE, (Object)((UnknownObject)object).getError());
    }

    @Test
    public void testUnrecognizedObjectClass() throws PCEPDeserializerException {
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object = this.ctx.getObjectHandlerRegistry().parseObject(35, 1, (ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof UnknownObject));
        Assert.assertEquals((Object)PCEPErrors.UNRECOGNIZED_OBJ_CLASS, (Object)((UnknownObject)object).getError());
    }

    @Test
    public void testLspaObjectSerializerDefence() throws IOException {
        PCEPLspaObjectParser parser = new PCEPLspaObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPLspaObject1LowerBounds.bin"));
        LspaBuilder builder = new LspaBuilder();
        builder.setProcessingRule(Boolean.valueOf(true));
        builder.setIgnore(Boolean.valueOf(true));
        builder.setLocalProtectionDesired(Boolean.valueOf(false));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
    }

    @Test
    public void testEmptyEroObject() throws PCEPDeserializerException {
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object = this.ctx.getObjectHandlerRegistry().parseObject(7, 1, (ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), Unpooled.EMPTY_BUFFER);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Ero));
        Ero eroObject = (Ero)object;
        Assert.assertNull((Object)eroObject.getSubobject());
        ByteBuf buffer = Unpooled.buffer();
        this.ctx.getObjectHandlerRegistry().serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)eroObject, buffer);
        byte[] expected = new byte[]{7, 19, 0, 4};
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteArray.getAllBytes((ByteBuf)buffer));
    }

    @Test
    public void testCloseObjectWithVendorInformationTlv() throws PCEPDeserializerException {
        byte[] closeBytes = new byte[]{15, 16, 0, 20, 0, 0, 0, 5, 0, 7, 0, 8, 0, 0, 0, 0, 0, 0, 0, 5};
        PCEPCloseObjectParser parser = new PCEPCloseObjectParser(this.tlvRegistry, this.viTlvRegistry);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])closeBytes);
        TestVendorInformationTlvParser.TestEnterpriseSpecificInformation esInfo = new TestVendorInformationTlvParser.TestEnterpriseSpecificInformation(5);
        VendorInformationTlv viTlv = new VendorInformationTlvBuilder().setEnterpriseNumber(new EnterpriseNumber(Uint32.ZERO)).setEnterpriseSpecificInformation((EnterpriseSpecificInformation)esInfo).build();
        CCloseBuilder builder = new CCloseBuilder().setProcessingRule(Boolean.valueOf(false)).setIgnore(Boolean.valueOf(false)).setReason(Uint8.valueOf((int)5)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.object.c.close.TlvsBuilder().setVendorInformationTlv((List)Lists.newArrayList((Object[])new VendorInformationTlv[]{viTlv})).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
    }

    @Test
    public void testVendorInformationObject() throws PCEPDeserializerException {
        byte[] viObjBytes = new byte[]{34, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 5};
        TestVendorInformationObjectParser parser = new TestVendorInformationObjectParser();
        TestVendorInformationTlvParser.TestEnterpriseSpecificInformation esInfo = new TestVendorInformationTlvParser.TestEnterpriseSpecificInformation(5);
        VendorInformationObject viObj = new VendorInformationObjectBuilder().setEnterpriseNumber(new EnterpriseNumber(Uint32.ZERO)).setEnterpriseSpecificInformation((EnterpriseSpecificInformation)esInfo).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])viObjBytes);
        result.readerIndex(8);
        VendorInformationObject o = (VendorInformationObject)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.readSlice(result.readableBytes()));
        Assert.assertEquals((Object)viObj, (Object)o);
        ByteBuf buf = Unpooled.buffer((int)viObjBytes.length);
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)viObj, buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
    }

    @Test
    public void testMonitoringObject() throws PCEPDeserializerException {
        byte[] monitoringBytes = new byte[]{19, 16, 0, 12, 0, 0, 0, 1, 0, 0, 0, 16};
        PCEPMonitoringObjectParser parser = new PCEPMonitoringObjectParser(this.tlvRegistry, this.viTlvRegistry);
        Monitoring monitoring = new MonitoringBuilder().setMonitoringId(Uint32.valueOf((long)16L)).setFlags(new Monitoring.Flags(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false))).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.monitoring.TlvsBuilder().build()).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])monitoringBytes);
        Assert.assertEquals((Object)monitoring, (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)monitoringBytes.length);
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)monitoring, buf);
        Assert.assertArrayEquals((byte[])monitoringBytes, (byte[])buf.array());
    }

    @Test
    public void testPccIdReqIPv4Object() throws PCEPDeserializerException {
        byte[] pccIdReqBytes = new byte[]{20, 16, 0, 8, 127, 0, 0, 1};
        PCEPPccIdReqIPv4ObjectParser parser = new PCEPPccIdReqIPv4ObjectParser();
        PccIdReq pccIdReq = new PccIdReqBuilder().setIpAddress(new IpAddressNoZone(new Ipv4AddressNoZone("127.0.0.1"))).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])pccIdReqBytes);
        Assert.assertEquals((Object)pccIdReq, (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)pccIdReqBytes.length);
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)pccIdReq, buf);
        Assert.assertArrayEquals((byte[])pccIdReqBytes, (byte[])buf.array());
    }

    @Test
    public void testPccIdReqIPv6Object() throws PCEPDeserializerException {
        byte[] pccIdReqBytes = new byte[]{20, 32, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        PCEPPccIdReqIPv6ObjectParser parser = new PCEPPccIdReqIPv6ObjectParser();
        PccIdReq pccIdReq = new PccIdReqBuilder().setIpAddress(new IpAddressNoZone(new Ipv6AddressNoZone("::1"))).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])pccIdReqBytes);
        Assert.assertEquals((Object)pccIdReq, (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)pccIdReqBytes.length);
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)pccIdReq, buf);
        Assert.assertArrayEquals((byte[])pccIdReqBytes, (byte[])buf.array());
    }

    @Test
    public void testPceIdIPv4Object() throws PCEPDeserializerException {
        byte[] pccIdReqBytes = new byte[]{25, 16, 0, 8, 127, 0, 0, 1};
        PCEPPceIdIPv4ObjectParser parser = new PCEPPceIdIPv4ObjectParser();
        PceId pceId = new PceIdBuilder().setIpAddress(new IpAddressNoZone(new Ipv4AddressNoZone("127.0.0.1"))).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])pccIdReqBytes);
        Assert.assertEquals((Object)pceId, (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)pccIdReqBytes.length);
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)pceId, buf);
        Assert.assertArrayEquals((byte[])pccIdReqBytes, (byte[])buf.array());
    }

    @Test
    public void testPceIdIPv6Object() throws PCEPDeserializerException {
        byte[] pccIdReqBytes = new byte[]{25, 32, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        PCEPPceIdIPv6ObjectParser parser = new PCEPPceIdIPv6ObjectParser();
        PceId pccIdReq = new PceIdBuilder().setIpAddress(new IpAddressNoZone(new Ipv6AddressNoZone("::1"))).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])pccIdReqBytes);
        Assert.assertEquals((Object)pccIdReq, (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)pccIdReqBytes.length);
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)pccIdReq, buf);
        Assert.assertArrayEquals((byte[])pccIdReqBytes, (byte[])buf.array());
    }

    @Test
    public void testProcTimeObject() throws PCEPDeserializerException {
        byte[] proctimeBytes = new byte[]{26, 16, 0, 28, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 4, 0, 0, 0, 5};
        PCEPProcTimeObjectParser parser = new PCEPProcTimeObjectParser();
        ProcTime procTime = new ProcTimeBuilder().setEstimated(Boolean.valueOf(true)).setAverageProcTime(Uint32.valueOf((int)4)).setCurrentProcTime(Uint32.ONE).setMaxProcTime(Uint32.valueOf((int)3)).setMinProcTime(Uint32.TWO).setVarianceProcTime(Uint32.valueOf((int)5)).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])proctimeBytes);
        Assert.assertEquals((Object)procTime, (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)proctimeBytes.length);
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)procTime, buf);
        Assert.assertArrayEquals((byte[])proctimeBytes, (byte[])buf.array());
    }

    @Test
    public void testOverloadObject() throws PCEPDeserializerException {
        byte[] overloadBytes = new byte[]{27, 16, 0, 8, 0, 0, 0, 120};
        PCEPOverloadObjectParser parser = new PCEPOverloadObjectParser();
        Overload overload = new OverloadBuilder().setDuration(Uint16.valueOf((int)120)).build();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])overloadBytes);
        Assert.assertEquals((Object)overload, (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer((int)overloadBytes.length);
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)overload, buf);
        Assert.assertArrayEquals((byte[])overloadBytes, (byte[])buf.array());
    }

    @Test
    public void testRpObjectWithPstTlvParser() throws PCEPDeserializerException {
        byte[] rpObjectWithPstTlvBytes = new byte[]{2, 16, 0, 20, 0, 0, 4, 45, -34, -83, -66, -17, 0, 28, 0, 4, 0, 0, 0, 0};
        PCEPRequestParameterObjectParser parser = new PCEPRequestParameterObjectParser(this.tlvRegistry, this.viTlvRegistry);
        RpBuilder builder = new RpBuilder().setProcessingRule(Boolean.valueOf(false)).setIgnore(Boolean.valueOf(false)).setReoptimization(Boolean.valueOf(true)).setBiDirectional(Boolean.valueOf(false)).setLoose(Boolean.valueOf(true)).setMakeBeforeBreak(Boolean.valueOf(true)).setOrder(Boolean.valueOf(false)).setPathKey(Boolean.valueOf(false)).setSupplyOf(Boolean.valueOf(false)).setFragmentation(Boolean.valueOf(false)).setP2mp(Boolean.valueOf(false)).setEroCompression(Boolean.valueOf(false)).setPriority(Uint8.valueOf((int)5)).setRequestId(new RequestId(Uint32.valueOf((long)3735928559L))).setTlvs(new TlvsBuilder().setPathSetupType(new PathSetupTypeBuilder().setPst(Uint8.ZERO).build()).build());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])rpObjectWithPstTlvBytes);
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])rpObjectWithPstTlvBytes, (byte[])ByteArray.getAllBytes((ByteBuf)buf));
    }

    @Test
    public void testBranchNodeListObject() throws Exception {
        byte[] expected = new byte[]{31, 16, 0, 12, -127, 8, -1, -1, -1, -1, 32, 0};
        BranchNodeListObjectParser parser = new BranchNodeListObjectParser(this.ctx.getEROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])expected);
        BranchNodeListBuilder builder = new BranchNodeListBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject> subs = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject>();
        subs.add(new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.255/32"))).build()).build()).build());
        builder.setSubobject(BNCUtil.toBncSubobject(subs));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testNonBranchNodeListObject() throws Exception {
        byte[] expected = new byte[]{31, 32, 0, 12, -127, 8, -1, -1, -1, -1, 32, 0};
        NonBranchNodeListObjectParser parser = new NonBranchNodeListObjectParser(this.ctx.getEROSubobjectHandlerRegistry());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])expected);
        NonBranchNodeListBuilder builder = new NonBranchNodeListBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject> subs = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject>();
        subs.add(new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.255/32"))).build()).build()).build());
        builder.setSubobject(BNCUtil.toBncSubobject(subs));
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        parser.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testPCEPIpv4UnreachDestinationObject() throws Exception {
        byte[] expected = new byte[]{28, 16, 0, 8, 127, 0, 0, 1};
        PCEPIpv4UnreachDestinationParser parser = new PCEPIpv4UnreachDestinationParser();
        PCEPUnreachDestinationSerializer serializer = new PCEPUnreachDestinationSerializer();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])expected);
        UnreachDestinationObjBuilder builder = new UnreachDestinationObjBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        Ipv4DestinationCase dest = new Ipv4DestinationCaseBuilder().setDestinationIpv4Address(Set.of(new Ipv4AddressNoZone("127.0.0.1"))).build();
        builder.setDestination((Destination)dest);
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        serializer.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testPCEPIpv6UnreachDestinationObject() throws Exception {
        byte[] expected = new byte[]{28, 32, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        PCEPIpv6UnreachDestinationParser parser = new PCEPIpv6UnreachDestinationParser();
        PCEPUnreachDestinationSerializer serializer = new PCEPUnreachDestinationSerializer();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])expected);
        UnreachDestinationObjBuilder builder = new UnreachDestinationObjBuilder();
        builder.setProcessingRule(Boolean.valueOf(false));
        builder.setIgnore(Boolean.valueOf(false));
        Ipv6DestinationCase dest = new Ipv6DestinationCaseBuilder().setDestinationIpv6Address(Set.of(new Ipv6AddressNoZone("::1"))).build();
        builder.setDestination((Destination)dest);
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(false), Boolean.valueOf(false)), result.slice(4, result.readableBytes() - 4)));
        ByteBuf buf = Unpooled.buffer();
        serializer.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])ByteArray.getAllBytes((ByteBuf)buf));
        try {
            parser.parseObject((ObjectHeader)new ObjectHeaderImpl(Boolean.valueOf(true), Boolean.valueOf(true)), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }
}

