/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.pcep.impl.spi.Util;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.SessionCase;

public class UtilTest {
    private static final Open OPEN = new OpenBuilder().build();

    @Test
    public void testCreateErrorMessageWithOpen() {
        Pcerr errMsg = Util.createErrorMessage((PCEPErrors)PCEPErrors.BAD_LABEL_VALUE, (Open)OPEN);
        MatcherAssert.assertThat((Object)errMsg.getPcerrMessage().getErrorType(), (Matcher)Matchers.isA(SessionCase.class));
        SessionCase sessionCase = (SessionCase)errMsg.getPcerrMessage().getErrorType();
        Assert.assertEquals((Object)OPEN, (Object)sessionCase.getSession().getOpen());
        ErrorObject errorObject = ((Errors)errMsg.getPcerrMessage().getErrors().get(0)).getErrorObject();
        Assert.assertEquals((Object)PCEPErrors.BAD_LABEL_VALUE.getErrorType(), (Object)errorObject.getType());
        Assert.assertEquals((Object)PCEPErrors.BAD_LABEL_VALUE.getErrorValue(), (Object)errorObject.getValue());
    }

    @Test
    public void testCreateErrorMessage() {
        Pcerr errMsg = Util.createErrorMessage((PCEPErrors)PCEPErrors.BAD_LABEL_VALUE, null);
        Assert.assertNull((Object)errMsg.getPcerrMessage().getErrorType());
        ErrorObject errorObject = ((Errors)errMsg.getPcerrMessage().getErrors().get(0)).getErrorObject();
        Assert.assertEquals((Object)PCEPErrors.BAD_LABEL_VALUE.getErrorType(), (Object)errorObject.getType());
        Assert.assertEquals((Object)PCEPErrors.BAD_LABEL_VALUE.getErrorValue(), (Object)errorObject.getValue());
    }
}

