package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * container pcep-session-config {
 *   leaf dead-timer-value {
 *     type uint16;
 *     default 120;
 *   }
 *   leaf keep-alive-timer-value {
 *     type uint16;
 *     default 30;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link PcepSessionConfigBuilder}.
 * @see PcepSessionConfigBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PcepSessionConfig
    extends
    ChildOf<PcepAppConfigData>,
    Augmentable<PcepSessionConfig>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("pcep-session-config");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfig> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfig.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.@NonNull PcepSessionConfig obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDeadTimerValue());
        result = prime * result + Objects.hashCode(obj.getKeepAliveTimerValue());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.@NonNull PcepSessionConfig thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfig other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfig.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDeadTimerValue(), other.getDeadTimerValue())) {
            return false;
        }
        if (!Objects.equals(thisObj.getKeepAliveTimerValue(), other.getKeepAliveTimerValue())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.@NonNull PcepSessionConfig obj) {
        final var helper = MoreObjects.toStringHelper("PcepSessionConfig");
        CodeHelpers.appendValue(helper, "deadTimerValue", obj.getDeadTimerValue());
        CodeHelpers.appendValue(helper, "keepAliveTimerValue", obj.getKeepAliveTimerValue());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return deadTimerValue, or {@code null} if it is not present.
     *
     * @return {@code Uint16} deadTimerValue, or {@code null} if it is not present.
     *
     */
    Uint16 getDeadTimerValue();
    
    /**
     * Return deadTimerValue, guaranteed to be non-null.
     *
     * @return {@code Uint16} deadTimerValue, guaranteed to be non-null.
     * @throws NoSuchElementException if deadTimerValue is not present
     *
     */
    default @NonNull Uint16 requireDeadTimerValue() {
        return CodeHelpers.require(getDeadTimerValue(), "deadtimervalue");
    }
    
    /**
     * Return keepAliveTimerValue, or {@code null} if it is not present.
     *
     * @return {@code Uint16} keepAliveTimerValue, or {@code null} if it is not present.
     *
     */
    Uint16 getKeepAliveTimerValue();
    
    /**
     * Return keepAliveTimerValue, guaranteed to be non-null.
     *
     * @return {@code Uint16} keepAliveTimerValue, guaranteed to be non-null.
     * @throws NoSuchElementException if keepAliveTimerValue is not present
     *
     */
    default @NonNull Uint16 requireKeepAliveTimerValue() {
        return CodeHelpers.require(getKeepAliveTimerValue(), "keepalivetimervalue");
    }

}

