package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.StoreType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * container tls {
 *   presence true;
 *   leaf keystore {
 *     type string;
 *   }
 *   leaf keystore-type {
 *     type store-type;
 *   }
 *   leaf keystore-path-type {
 *     type path-type;
 *   }
 *   leaf keystore-password {
 *     type string;
 *   }
 *   leaf certificate-password {
 *     type string;
 *   }
 *   leaf truststore {
 *     type string;
 *   }
 *   leaf truststore-type {
 *     type store-type;
 *   }
 *   leaf truststore-path-type {
 *     type path-type;
 *   }
 *   leaf truststore-password {
 *     type string;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link TlsBuilder}.
 * @see TlsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Tls
    extends
    ChildOf<PcepDispatcherConfig>,
    Augmentable<Tls>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("tls");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.@NonNull Tls obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getCertificatePassword());
        result = prime * result + Objects.hashCode(obj.getKeystore());
        result = prime * result + Objects.hashCode(obj.getKeystorePassword());
        result = prime * result + Objects.hashCode(obj.getKeystorePathType());
        result = prime * result + Objects.hashCode(obj.getKeystoreType());
        result = prime * result + Objects.hashCode(obj.getTruststore());
        result = prime * result + Objects.hashCode(obj.getTruststorePassword());
        result = prime * result + Objects.hashCode(obj.getTruststorePathType());
        result = prime * result + Objects.hashCode(obj.getTruststoreType());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.@NonNull Tls thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getCertificatePassword(), other.getCertificatePassword())) {
            return false;
        }
        if (!Objects.equals(thisObj.getKeystore(), other.getKeystore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getKeystorePassword(), other.getKeystorePassword())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTruststore(), other.getTruststore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTruststorePassword(), other.getTruststorePassword())) {
            return false;
        }
        if (!Objects.equals(thisObj.getKeystorePathType(), other.getKeystorePathType())) {
            return false;
        }
        if (!Objects.equals(thisObj.getKeystoreType(), other.getKeystoreType())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTruststorePathType(), other.getTruststorePathType())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTruststoreType(), other.getTruststoreType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.@NonNull Tls obj) {
        final var helper = MoreObjects.toStringHelper("Tls");
        CodeHelpers.appendValue(helper, "certificatePassword", obj.getCertificatePassword());
        CodeHelpers.appendValue(helper, "keystore", obj.getKeystore());
        CodeHelpers.appendValue(helper, "keystorePassword", obj.getKeystorePassword());
        CodeHelpers.appendValue(helper, "keystorePathType", obj.getKeystorePathType());
        CodeHelpers.appendValue(helper, "keystoreType", obj.getKeystoreType());
        CodeHelpers.appendValue(helper, "truststore", obj.getTruststore());
        CodeHelpers.appendValue(helper, "truststorePassword", obj.getTruststorePassword());
        CodeHelpers.appendValue(helper, "truststorePathType", obj.getTruststorePathType());
        CodeHelpers.appendValue(helper, "truststoreType", obj.getTruststoreType());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return keystore, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore location
     *     </code>
     * </pre>
     *
     * @return {@code String} keystore, or {@code null} if it is not present.
     *
     */
    String getKeystore();
    
    /**
     * Return keystore, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore location
     *     </code>
     * </pre>
     *
     * @return {@code String} keystore, guaranteed to be non-null.
     * @throws NoSuchElementException if keystore is not present
     *
     */
    default @NonNull String requireKeystore() {
        return CodeHelpers.require(getKeystore(), "keystore");
    }
    
    /**
     * Return keystoreType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore type (JKS or PKCS12)
     *     </code>
     * </pre>
     *
     * @return {@code StoreType} keystoreType, or {@code null} if it is not present.
     *
     */
    StoreType getKeystoreType();
    
    /**
     * Return keystoreType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore type (JKS or PKCS12)
     *     </code>
     * </pre>
     *
     * @return {@code StoreType} keystoreType, guaranteed to be non-null.
     * @throws NoSuchElementException if keystoreType is not present
     *
     */
    default @NonNull StoreType requireKeystoreType() {
        return CodeHelpers.require(getKeystoreType(), "keystoretype");
    }
    
    /**
     * Return keystorePathType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         keystore path type (CLASSPATH or PATH)
     *     </code>
     * </pre>
     *
     * @return {@code PathType} keystorePathType, or {@code null} if it is not present.
     *
     */
    PathType getKeystorePathType();
    
    /**
     * Return keystorePathType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         keystore path type (CLASSPATH or PATH)
     *     </code>
     * </pre>
     *
     * @return {@code PathType} keystorePathType, guaranteed to be non-null.
     * @throws NoSuchElementException if keystorePathType is not present
     *
     */
    default @NonNull PathType requireKeystorePathType() {
        return CodeHelpers.require(getKeystorePathType(), "keystorepathtype");
    }
    
    /**
     * Return keystorePassword, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         password protecting keystore
     *     </code>
     * </pre>
     *
     * @return {@code String} keystorePassword, or {@code null} if it is not present.
     *
     */
    String getKeystorePassword();
    
    /**
     * Return keystorePassword, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         password protecting keystore
     *     </code>
     * </pre>
     *
     * @return {@code String} keystorePassword, guaranteed to be non-null.
     * @throws NoSuchElementException if keystorePassword is not present
     *
     */
    default @NonNull String requireKeystorePassword() {
        return CodeHelpers.require(getKeystorePassword(), "keystorepassword");
    }
    
    /**
     * Return certificatePassword, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         password protecting certificate
     *     </code>
     * </pre>
     *
     * @return {@code String} certificatePassword, or {@code null} if it is not present.
     *
     */
    String getCertificatePassword();
    
    /**
     * Return certificatePassword, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         password protecting certificate
     *     </code>
     * </pre>
     *
     * @return {@code String} certificatePassword, guaranteed to be non-null.
     * @throws NoSuchElementException if certificatePassword is not present
     *
     */
    default @NonNull String requireCertificatePassword() {
        return CodeHelpers.require(getCertificatePassword(), "certificatepassword");
    }
    
    /**
     * Return truststore, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         truststore location
     *     </code>
     * </pre>
     *
     * @return {@code String} truststore, or {@code null} if it is not present.
     *
     */
    String getTruststore();
    
    /**
     * Return truststore, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         truststore location
     *     </code>
     * </pre>
     *
     * @return {@code String} truststore, guaranteed to be non-null.
     * @throws NoSuchElementException if truststore is not present
     *
     */
    default @NonNull String requireTruststore() {
        return CodeHelpers.require(getTruststore(), "truststore");
    }
    
    /**
     * Return truststoreType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         truststore type (JKS or PKCS12)
     *     </code>
     * </pre>
     *
     * @return {@code StoreType} truststoreType, or {@code null} if it is not present.
     *
     */
    StoreType getTruststoreType();
    
    /**
     * Return truststoreType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         truststore type (JKS or PKCS12)
     *     </code>
     * </pre>
     *
     * @return {@code StoreType} truststoreType, guaranteed to be non-null.
     * @throws NoSuchElementException if truststoreType is not present
     *
     */
    default @NonNull StoreType requireTruststoreType() {
        return CodeHelpers.require(getTruststoreType(), "truststoretype");
    }
    
    /**
     * Return truststorePathType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         truststore path type (CLASSPATH or PATH)
     *     </code>
     * </pre>
     *
     * @return {@code PathType} truststorePathType, or {@code null} if it is not present.
     *
     */
    PathType getTruststorePathType();
    
    /**
     * Return truststorePathType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         truststore path type (CLASSPATH or PATH)
     *     </code>
     * </pre>
     *
     * @return {@code PathType} truststorePathType, guaranteed to be non-null.
     * @throws NoSuchElementException if truststorePathType is not present
     *
     */
    default @NonNull PathType requireTruststorePathType() {
        return CodeHelpers.require(getTruststorePathType(), "truststorepathtype");
    }
    
    /**
     * Return truststorePassword, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         password protecting truststore
     *     </code>
     * </pre>
     *
     * @return {@code String} truststorePassword, or {@code null} if it is not present.
     *
     */
    String getTruststorePassword();
    
    /**
     * Return truststorePassword, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         password protecting truststore
     *     </code>
     * </pre>
     *
     * @return {@code String} truststorePassword, guaranteed to be non-null.
     * @throws NoSuchElementException if truststorePassword is not present
     *
     */
    default @NonNull String requireTruststorePassword() {
        return CodeHelpers.require(getTruststorePassword(), "truststorepassword");
    }

}

