/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.NoPathVectorTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.OFListTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.OrderTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.OverloadedDurationTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.PathSetupTypeTlvParser;
import org.opendaylight.protocol.pcep.parser.tlv.ReqMissingTlvParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.NoPathVectorTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.list.tlv.OfList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.list.tlv.OfListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.OrderBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDurationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.tlvs.NoPathVector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.tlvs.NoPathVectorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.req.missing.tlv.ReqMissing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.req.missing.tlv.ReqMissingBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlvBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

public class PCEPTlvParserTest {
    private static final byte[] NO_PATH_VECTOR_BYTES = new byte[]{0, 1, 0, 4, 0, 0, 0, -89};
    private static final byte[] OVERLOADED_BYTES = new byte[]{0, 2, 0, 4, 127, -1, -1, -1};
    private static final byte[] REQ_MISSING_BYTES = new byte[]{0, 3, 0, 4, -9, -126, 53, 23};
    private static final byte[] ORDER_BYTES = new byte[]{0, 5, 0, 8, -1, -1, -1, -1, 0, 0, 0, 1};
    private static final byte[] OF_LIST_BYTES = new byte[]{0, 4, 0, 4, 18, 52, 86, 120};
    private static final byte[] VENDOR_INFO_BYTES = new byte[]{0, 7, 0, 8, 0, 0, 0, 0, 0, 0, 0, 5};
    private static final byte[] PST_TLV_BYTES = new byte[]{0, 28, 0, 4, 0, 0, 0, 0};
    private static final byte[] PST_TLV_BYTES_UNSUPPORTED = new byte[]{0, 28, 0, 4, 0, 0, 0, 1};

    @Test
    public void testNoPathVectorTlv() throws PCEPDeserializerException {
        NoPathVectorTlvParser parser = new NoPathVectorTlvParser();
        NoPathVector tlv = new NoPathVectorBuilder().setFlags(new NoPathVectorTlv.Flags(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true))).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])NO_PATH_VECTOR_BYTES, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])NO_PATH_VECTOR_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testOverloadedDurationTlv() throws PCEPDeserializerException {
        OverloadedDurationTlvParser parser = new OverloadedDurationTlvParser();
        OverloadDuration tlv = new OverloadDurationBuilder().setDuration(Uint32.valueOf((long)Integer.MAX_VALUE)).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])OVERLOADED_BYTES, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])OVERLOADED_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testReqMissingTlv() throws PCEPDeserializerException {
        ReqMissingTlvParser parser = new ReqMissingTlvParser();
        ReqMissing tlv = new ReqMissingBuilder().setRequestId(new RequestId(Uint32.valueOf((long)4152505623L))).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])REQ_MISSING_BYTES, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])REQ_MISSING_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testOrderTlv() throws PCEPDeserializerException {
        OrderTlvParser parser = new OrderTlvParser();
        Order tlv = new OrderBuilder().setDelete(Uint32.valueOf((long)0xFFFFFFFFL)).setSetup(Uint32.valueOf((long)1L)).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])ORDER_BYTES, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])ORDER_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testOFListTlv() throws PCEPDeserializerException {
        OFListTlvParser parser = new OFListTlvParser();
        OfList tlv = new OfListBuilder().setCodes((Set)ImmutableSet.of((Object)new OfId(Uint16.valueOf((int)4660)), (Object)new OfId(Uint16.valueOf((int)22136)))).build();
        Assert.assertEquals((Object)tlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])OF_LIST_BYTES, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)tlv, buff);
        Assert.assertArrayEquals((byte[])OF_LIST_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testVendorInformationTlv() throws PCEPDeserializerException {
        TestVendorInformationTlvParser parser = new TestVendorInformationTlvParser();
        TestVendorInformationTlvParser.TestEnterpriseSpecificInformation esInfo = new TestVendorInformationTlvParser.TestEnterpriseSpecificInformation(5);
        VendorInformationTlv viTlv = new VendorInformationTlvBuilder().setEnterpriseNumber(new EnterpriseNumber(Uint32.ZERO)).setEnterpriseSpecificInformation((EnterpriseSpecificInformation)esInfo).build();
        VendorInformationTlv parsedTlv = parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])VENDOR_INFO_BYTES, (int)8)));
        Assert.assertEquals((Object)viTlv, (Object)parsedTlv);
        ByteBuf buff = Unpooled.buffer((int)VENDOR_INFO_BYTES.length);
        parser.serializeTlv((Tlv)viTlv, buff);
        Assert.assertArrayEquals((byte[])VENDOR_INFO_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        Assert.assertNull((Object)parser.parseTlv(null));
    }

    @Test
    public void testPathSetupTypeTlvParser() throws PCEPDeserializerException {
        PathSetupTypeTlvParser parser = new PathSetupTypeTlvParser();
        PathSetupType pstTlv = new PathSetupTypeBuilder().setPst(Uint8.ZERO).build();
        Assert.assertEquals((Object)pstTlv, (Object)parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])PST_TLV_BYTES, (int)4))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)pstTlv, buff);
        Assert.assertArrayEquals((byte[])PST_TLV_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
    }

    @Test(expected=PCEPDeserializerException.class)
    public void testUnsupportedPSTParser() throws PCEPDeserializerException {
        PathSetupTypeTlvParser parser = new PathSetupTypeTlvParser();
        parser.parseTlv(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])PST_TLV_BYTES_UNSUPPORTED, (int)4)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnsupportedPSTSerializer() {
        PathSetupTypeTlvParser parser = new PathSetupTypeTlvParser();
        PathSetupType pstTlv = new PathSetupTypeBuilder().setPst(Uint8.ONE).build();
        ByteBuf buff = Unpooled.buffer();
        parser.serializeTlv((Tlv)pstTlv, buff);
    }
}

