/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.pcep.parser.BaseParserExtensionActivator;
import org.opendaylight.protocol.pcep.parser.subobject.RROIpv4PrefixSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.RROIpv6PrefixSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.RROLabelSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.RROPathKey128SubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.RROPathKey32SubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.RROUnnumberedInterfaceSubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.spi.pojo.SimplePCEPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.LabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.PathKeyCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.UnnumberedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.label._case.LabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.path.key._case.PathKeyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.GeneralizedLabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.generalized.label._case.GeneralizedLabelBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class PcepRROSubobjectParserTest {
    private static final byte[] IP4_PREFIX_BYTES = new byte[]{1, 8, -1, -1, -1, -1, 22, 1};
    private static final byte[] IP6_PREFIX_BYTES = new byte[]{2, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, 2};
    private static final byte[] UNNUMBERED_BYTES = new byte[]{4, 12, 2, 0, 18, 52, 80, 0, -1, -1, -1, -1};
    private static final byte[] PATH_KEY32_BYTES = new byte[]{64, 8, 18, 52, 18, 52, 80, 0};
    private static final byte[] PATH_KEY128_BYTES = new byte[]{65, 20, 18, 52, 18, 52, 86, 120, -102, -68, -34, 18, 52, 84, 0, 0, 0, 0, 0, 0};
    private static final byte[] LABEL_BYTES = new byte[]{3, 8, -128, 2, 18, 0, 37, -1};

    @Test
    public void testRROIp4PrefixSubobject() throws PCEPDeserializerException {
        RROIpv4PrefixSubobjectParser parser = new RROIpv4PrefixSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder().setProtectionAvailable(Boolean.valueOf(true)).setProtectionInUse(Boolean.valueOf(false)).setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.255/22"))).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])IP4_PREFIX_BYTES, (int)2))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])IP4_PREFIX_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRROIp6PrefixSubobject() throws PCEPDeserializerException {
        RROIpv6PrefixSubobjectParser parser = new RROIpv6PrefixSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder().setProtectionAvailable(Boolean.valueOf(false)).setProtectionInUse(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(Ipv6Util.prefixForBytes((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)22))).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])IP6_PREFIX_BYTES, (int)2))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])IP6_PREFIX_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRROUnnumberedSubobject() throws PCEPDeserializerException {
        RROUnnumberedInterfaceSubobjectParser parser = new RROUnnumberedInterfaceSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder().setProtectionAvailable(Boolean.valueOf(false)).setProtectionInUse(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(new UnnumberedBuilder().setRouterId(Uint32.valueOf((long)305418240L)).setInterfaceId(Uint32.valueOf((long)0xFFFFFFFFL)).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])UNNUMBERED_BYTES, (int)2))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])UNNUMBERED_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRROPathKey32Subobject() throws PCEPDeserializerException {
        RROPathKey32SubobjectParser parser = new RROPathKey32SubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder();
        PathKeyBuilder pBuilder = new PathKeyBuilder().setPceId(new PceId(new byte[]{18, 52, 80, 0})).setPathKey(new PathKey(Uint16.valueOf((int)4660)));
        subs.setSubobjectType((SubobjectType)new PathKeyCaseBuilder().setPathKey(pBuilder.build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])PATH_KEY32_BYTES, (int)2))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])PATH_KEY32_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRROPathKey128Subobject() throws PCEPDeserializerException {
        RROPathKey128SubobjectParser parser = new RROPathKey128SubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder();
        PathKeyBuilder pBuilder = new PathKeyBuilder().setPceId(new PceId(new byte[]{18, 52, 86, 120, -102, -68, -34, 18, 52, 84, 0, 0, 0, 0, 0, 0})).setPathKey(new PathKey(Uint16.valueOf((int)4660)));
        subs.setSubobjectType((SubobjectType)new PathKeyCaseBuilder().setPathKey(pBuilder.build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])PATH_KEY128_BYTES, (int)2))));
        ByteBuf buff = Unpooled.buffer();
        RROPathKey128SubobjectParser.serializeSubobject((Subobject)subs.build(), (ByteBuf)buff);
        Assert.assertArrayEquals((byte[])PATH_KEY128_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRROLabelSubobject() throws Exception {
        SimplePCEPExtensionProviderContext ctx = new SimplePCEPExtensionProviderContext();
        BaseParserExtensionActivator act = new BaseParserExtensionActivator();
        act.start((PCEPExtensionProviderContext)ctx);
        RROLabelSubobjectParser parser = new RROLabelSubobjectParser(ctx.getLabelHandlerRegistry());
        SubobjectBuilder subs = new SubobjectBuilder().setSubobjectType((SubobjectType)new LabelCaseBuilder().setLabel(new LabelBuilder().setUniDirectional(Boolean.valueOf(true)).setGlobal(Boolean.valueOf(false)).setLabelType((LabelType)new GeneralizedLabelCaseBuilder().setGeneralizedLabel(new GeneralizedLabelBuilder().setGeneralizedLabel(new byte[]{18, 0, 37, -1}).build()).build()).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])LABEL_BYTES, (int)2))));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])LABEL_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }
}

