/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.parser.tlv.AbstractVendorInformationTlvParser;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yangtools.yang.common.Uint32;

public class TestVendorInformationTlvParser
extends AbstractVendorInformationTlvParser {
    private static final EnterpriseNumber TEST_ENTERPRISE_NUMBER = new EnterpriseNumber(Uint32.ZERO);

    public void serializeEnterpriseSpecificInformation(EnterpriseSpecificInformation enterpriseSpecificInformation, ByteBuf buffer) {
        if (enterpriseSpecificInformation instanceof TestEnterpriseSpecificInformation) {
            buffer.writeInt(((TestEnterpriseSpecificInformation)enterpriseSpecificInformation).getValue());
        }
    }

    public EnterpriseSpecificInformation parseEnterpriseSpecificInformation(ByteBuf buffer) {
        return new TestEnterpriseSpecificInformation(buffer.readInt());
    }

    public EnterpriseNumber getEnterpriseNumber() {
        return TEST_ENTERPRISE_NUMBER;
    }

    protected static final class TestEnterpriseSpecificInformation
    implements EnterpriseSpecificInformation {
        private final int value;

        public TestEnterpriseSpecificInformation(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public Class<TestEnterpriseSpecificInformation> implementedInterface() {
            return TestEnterpriseSpecificInformation.class;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestEnterpriseSpecificInformation other = (TestEnterpriseSpecificInformation)obj;
            return this.value == other.value;
        }
    }
}

