package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * typedef store-type {
 *   type enumeration {
 *     enum JKS;
 *     enum PKCS12;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum StoreType implements Enumeration {
    JKS(0, "JKS"),
    
    PKCS12(1, "PKCS12")
    ;

    private final @NonNull String name;
    private final int value;

    private StoreType(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding StoreType item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable StoreType forName(String name) {
        return switch (name) {
            case "JKS" -> JKS;
            case "PKCS12" -> PKCS12;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding StoreType item, or {@code null} if no such item exists
     */
    public static @Nullable StoreType forValue(int intValue) {
        return switch (intValue) {
            case 0 -> JKS;
            case 1 -> PKCS12;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding StoreType item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull StoreType ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding StoreType item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull StoreType ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
