/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.opendaylight.protocol.pcep.impl.AbstractSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.protocol.pcep.impl.spi.Util;
import org.opendaylight.protocol.pcep.impl.tls.SslContextFactory;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.KeepaliveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Starttls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.StarttlsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.keepalive.message.KeepaliveMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.message.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.message.OpenMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.SessionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.start.tls.message.StartTlsMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPCEPSessionNegotiator
extends AbstractSessionNegotiator {
    public static final int FAIL_TIMER_VALUE = 60;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPCEPSessionNegotiator.class);
    private static final Keepalive KEEPALIVE = new KeepaliveBuilder().setKeepaliveMessage(new KeepaliveMessageBuilder().build()).build();
    private volatile boolean localOK;
    private volatile boolean openRetry;
    private volatile boolean remoteOK;
    private volatile State state = State.IDLE;
    private Future<?> failTimer;
    private Open localPrefs;
    private Open remotePrefs;
    private Tls tlsConfiguration;

    protected AbstractPCEPSessionNegotiator(Promise<PCEPSessionImpl> promise, Channel channel) {
        super(promise, channel);
    }

    protected abstract Open getInitialProposal();

    protected abstract Open getRevisedProposal(Open var1);

    protected abstract boolean isProposalAcceptable(Open var1);

    protected abstract Open getCounterProposal(Open var1);

    protected abstract PCEPSessionImpl createSession(Channel var1, Open var2, Open var3);

    private void sendErrorMessage(PCEPErrors value) {
        this.sendMessage((Message)Util.createErrorMessage(value, null));
    }

    private void scheduleFailTimer() {
        this.failTimer = this.channel.eventLoop().schedule(() -> {
            switch (this.state) {
                case FINISHED: 
                case IDLE: {
                    break;
                }
                case START_TLS_WAIT: {
                    this.sendErrorMessage(PCEPErrors.STARTTLS_TIMER_EXP);
                    this.negotiationFailed(new TimeoutException("StartTLSWait timer expired"));
                    this.state = State.FINISHED;
                    break;
                }
                case KEEP_WAIT: {
                    this.sendErrorMessage(PCEPErrors.NO_MSG_BEFORE_EXP_KEEPWAIT);
                    this.negotiationFailed(new TimeoutException("KeepWait timer expired"));
                    this.state = State.FINISHED;
                    break;
                }
                case OPEN_WAIT: {
                    this.sendErrorMessage(PCEPErrors.NO_OPEN_BEFORE_EXP_OPENWAIT);
                    this.negotiationFailed(new TimeoutException("OpenWait timer expired"));
                    this.state = State.FINISHED;
                    break;
                }
            }
        }, 60L, TimeUnit.SECONDS);
    }

    @Override
    protected final void startNegotiation() {
        Preconditions.checkState((this.state == State.IDLE ? 1 : 0) != 0);
        if (this.tlsConfiguration != null) {
            this.sendMessage((Message)new StarttlsBuilder().setStartTlsMessage(new StartTlsMessageBuilder().build()).build());
            this.state = State.START_TLS_WAIT;
            this.scheduleFailTimer();
            LOG.info("Started TLS connection negotiation with peer {}", (Object)this.channel);
        } else {
            this.startNegotiationWithOpen();
        }
        this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)f -> this.cancelTimers()));
    }

    private void cancelTimers() {
        this.failTimer.cancel(false);
    }

    private void startNegotiationWithOpen() {
        this.localPrefs = this.getInitialProposal();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open m = new OpenBuilder().setOpenMessage(new OpenMessageBuilder().setOpen(this.localPrefs).build()).build();
        this.sendMessage((Message)m);
        this.state = State.OPEN_WAIT;
        this.scheduleFailTimer();
        LOG.info("PCEP session with {} started, sent proposal {}", (Object)this.channel, (Object)this.localPrefs);
    }

    private boolean handleMessageKeepWait(Message msg) {
        if (msg instanceof Keepalive) {
            return this.handleMessageKeepAlive();
        }
        if (msg instanceof Pcerr) {
            return this.handleMessagePcerr(msg);
        }
        return false;
    }

    private boolean handleMessageKeepAlive() {
        this.localOK = true;
        if (this.remoteOK) {
            LOG.info("PCEP peer {} completed negotiation", (Object)this.channel);
            this.negotiationSuccessful(this.createSession(this.channel, this.localPrefs, this.remotePrefs));
            this.state = State.FINISHED;
        } else {
            this.scheduleFailTimer();
            this.state = State.OPEN_WAIT;
            LOG.debug("Channel {} moved to OpenWait state with localOK=1", (Object)this.channel);
        }
        return true;
    }

    private boolean handleMessagePcerr(Message msg) {
        PcerrMessage err = ((Pcerr)msg).getPcerrMessage();
        if (err.getErrorType() == null) {
            ErrorObject obj = ((Errors)err.getErrors().get(0)).getErrorObject();
            LOG.warn("Unexpected error received from PCC: type {} value {}", (Object)obj.getType(), (Object)obj.getValue());
            this.negotiationFailed(new IllegalStateException("Unexpected error received from PCC."));
            this.state = State.IDLE;
            return true;
        }
        this.localPrefs = this.getRevisedProposal(((SessionCase)err.getErrorType()).getSession().getOpen());
        if (this.localPrefs == null) {
            this.sendErrorMessage(PCEPErrors.PCERR_NON_ACC_SESSION_CHAR);
            this.negotiationFailed(new IllegalStateException("Peer suggested unacceptable retry proposal"));
            this.state = State.FINISHED;
            return true;
        }
        this.sendMessage((Message)new OpenBuilder().setOpenMessage(new OpenMessageBuilder().setOpen(this.localPrefs).build()).build());
        if (!this.remoteOK) {
            this.state = State.OPEN_WAIT;
        }
        this.scheduleFailTimer();
        return true;
    }

    private boolean handleMessageOpenWait(Message msg) {
        if (!(msg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open)) {
            return false;
        }
        OpenMessage o = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open)msg).getOpenMessage();
        Open open = o.getOpen();
        if (this.isProposalAcceptable(open)) {
            this.sendMessage((Message)KEEPALIVE);
            this.remotePrefs = open;
            this.remoteOK = true;
            if (this.localOK) {
                this.negotiationSuccessful(this.createSession(this.channel, this.localPrefs, this.remotePrefs));
                LOG.info("PCEP peer {} completed negotiation", (Object)this.channel);
                this.state = State.FINISHED;
            } else {
                this.scheduleFailTimer();
                this.state = State.KEEP_WAIT;
                LOG.debug("Channel {} moved to KeepWait state with remoteOK=1", (Object)this.channel);
            }
            return true;
        }
        if (this.openRetry) {
            this.sendErrorMessage(PCEPErrors.SECOND_OPEN_MSG);
            this.negotiationFailed(new IllegalStateException("OPEN renegotiation failed"));
            this.state = State.FINISHED;
            return true;
        }
        Open newPrefs = this.getCounterProposal(open);
        if (newPrefs == null) {
            this.sendErrorMessage(PCEPErrors.NON_ACC_NON_NEG_SESSION_CHAR);
            this.negotiationFailed(new IllegalStateException("Peer sent unacceptable session parameters"));
            this.state = State.FINISHED;
            return true;
        }
        this.sendMessage((Message)Util.createErrorMessage(PCEPErrors.NON_ACC_NEG_SESSION_CHAR, newPrefs));
        this.openRetry = true;
        this.state = this.localOK ? State.OPEN_WAIT : State.KEEP_WAIT;
        this.scheduleFailTimer();
        return true;
    }

    private boolean handleMessageStartTlsWait(Message msg) {
        if (msg instanceof Starttls) {
            SslContextFactory sslFactory = new SslContextFactory(this.tlsConfiguration);
            SSLContext sslContext = sslFactory.getServerContext();
            if (sslContext == null) {
                this.sendErrorMessage(PCEPErrors.NOT_POSSIBLE_WITHOUT_TLS);
                this.negotiationFailed(new IllegalStateException("Failed to establish a TLS connection."));
                this.state = State.FINISHED;
                return true;
            }
            SSLEngine engine = sslContext.createSSLEngine();
            engine.setNeedClientAuth(true);
            engine.setUseClientMode(false);
            this.channel.pipeline().addFirst(new ChannelHandler[]{new SslHandler(engine)});
            LOG.info("PCEPS TLS connection with peer: {} established succesfully.", (Object)this.channel);
            this.startNegotiationWithOpen();
            return true;
        }
        if (!(msg instanceof Pcerr)) {
            this.sendErrorMessage(PCEPErrors.NON_STARTTLS_MSG_RCVD);
            this.negotiationFailed(new IllegalStateException("Unexpected message recieved."));
            this.state = State.FINISHED;
            return true;
        }
        return false;
    }

    @Override
    protected final void handleMessage(Message msg) {
        this.cancelTimers();
        LOG.debug("Channel {} handling message {} in state {}", new Object[]{this.channel, msg, this.state});
        switch (this.state) {
            case FINISHED: 
            case IDLE: {
                throw new IllegalStateException("Unexpected handleMessage in state " + this.state);
            }
            case START_TLS_WAIT: {
                if (!this.handleMessageStartTlsWait(msg)) break;
                return;
            }
            case KEEP_WAIT: {
                if (!this.handleMessageKeepWait(msg)) break;
                return;
            }
            case OPEN_WAIT: {
                if (!this.handleMessageOpenWait(msg)) break;
                return;
            }
        }
        LOG.warn("Channel {} in state {} received unexpected message {}", new Object[]{this.channel, this.state, msg});
        this.sendErrorMessage(PCEPErrors.NON_OR_INVALID_OPEN_MSG);
        this.negotiationFailed(new Exception("Illegal message encountered"));
        this.state = State.FINISHED;
    }

    @VisibleForTesting
    State getState() {
        return this.state;
    }

    public void setTlsConfiguration(Tls tlsConfiguration) {
        this.tlsConfiguration = tlsConfiguration;
    }

    @Override
    protected void negotiationFailed(Throwable cause) {
        LOG.debug("Negotiation on channel {} failed", (Object)this.channel, (Object)cause);
        this.channel.close();
        this.promise.setFailure(cause);
    }

    @VisibleForTesting
    public static enum State {
        IDLE,
        START_TLS_WAIT,
        OPEN_WAIT,
        KEEP_WAIT,
        FINISHED;

    }
}

