/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;

public class PcepDispatcherConfigBuilder {
    private Uint16 _maxUnknownMessages;
    private Tls _tls;
    Map<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> augmentation = Map.of();

    public PcepDispatcherConfigBuilder() {
    }

    public PcepDispatcherConfigBuilder(PcepDispatcherConfig base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>>(aug);
        }
        this._maxUnknownMessages = base.getMaxUnknownMessages();
        this._tls = base.getTls();
    }

    public Uint16 getMaxUnknownMessages() {
        return this._maxUnknownMessages;
    }

    public Tls getTls() {
        return this._tls;
    }

    public <E$$ extends Augmentation<PcepDispatcherConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkMaxUnknownMessagesRange(int value) {
        if (value >= 1) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..65535]]", (int)value);
    }

    public PcepDispatcherConfigBuilder setMaxUnknownMessages(Uint16 value) {
        if (value != null) {
            PcepDispatcherConfigBuilder.checkMaxUnknownMessagesRange(value.intValue());
        }
        this._maxUnknownMessages = value;
        return this;
    }

    public PcepDispatcherConfigBuilder setTls(Tls value) {
        this._tls = value;
        return this;
    }

    public PcepDispatcherConfigBuilder addAugmentation(Augmentation<PcepDispatcherConfig> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public PcepDispatcherConfigBuilder removeAugmentation(Class<? extends Augmentation<PcepDispatcherConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull PcepDispatcherConfig build() {
        return new PcepDispatcherConfigImpl(this);
    }

    private static final class PcepDispatcherConfigImpl
    extends AbstractAugmentable<PcepDispatcherConfig>
    implements PcepDispatcherConfig {
        private final Uint16 _maxUnknownMessages;
        private final Tls _tls;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcepDispatcherConfigImpl(PcepDispatcherConfigBuilder base) {
            super(base.augmentation);
            this._maxUnknownMessages = base.getMaxUnknownMessages();
            this._tls = base.getTls();
        }

        @Override
        public Uint16 getMaxUnknownMessages() {
            return this._maxUnknownMessages;
        }

        @Override
        public Tls getTls() {
            return this._tls;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = PcepDispatcherConfig.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return PcepDispatcherConfig.bindingEquals(this, obj);
        }

        public String toString() {
            return PcepDispatcherConfig.bindingToString(this);
        }
    }
}

