/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum StoreType implements Enumeration
{
    JKS(0, "JKS"),
    PKCS12(1, "PKCS12");

    private final @NonNull String name;
    private final int value;

    private StoreType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static @Nullable StoreType forName(String name) {
        return switch (name) {
            case "JKS" -> JKS;
            case "PKCS12" -> PKCS12;
            default -> null;
        };
    }

    public static @Nullable StoreType forValue(int intValue) {
        return switch (intValue) {
            case 0 -> JKS;
            case 1 -> PKCS12;
            default -> null;
        };
    }

    public static @NonNull StoreType ofName(String name) {
        return (StoreType)CodeHelpers.checkEnum((Enumeration)StoreType.forName(name), (String)name);
    }

    public static @NonNull StoreType ofValue(int intValue) {
        return (StoreType)CodeHelpers.checkEnum((Enumeration)StoreType.forValue(intValue), (int)intValue);
    }
}

