/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.opendaylight.protocol.pcep.impl.SimpleSessionListener;
import org.opendaylight.protocol.util.InetSocketAddressUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Close;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.CloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.KeepaliveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Starttls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.StarttlsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.message.CCloseMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.object.CCloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.keepalive.message.KeepaliveMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.message.OpenMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.start.tls.message.StartTlsMessageBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.Uint8;

public class AbstractPCEPSessionTest {
    protected static final Uint8 KEEP_ALIVE = Uint8.valueOf((int)15);
    protected static final Uint8 DEADTIMER = Uint8.valueOf((int)40);
    @Mock
    protected Channel channel;
    @Mock
    private ChannelFuture channelFuture;
    @Mock
    private EventLoop eventLoop;
    @Mock
    private ScheduledFuture<?> future;
    @Mock
    private ChannelPipeline pipeline;
    @Mock
    private SocketAddress address;
    protected final String ipAddress = InetSocketAddressUtil.getRandomLoopbackIpAddress();
    protected final int port = InetSocketAddressUtil.getRandomPort();
    protected final List<Notification<?>> msgsSend = new ArrayList();
    protected Open openMsg;
    protected Close closeMsg;
    protected Starttls startTlsMsg;
    protected Keepalive kaMsg;
    protected SimpleSessionListener listener;

    @Before
    public final void setUp() {
        DefaultChannelPromise cfuture = new DefaultChannelPromise(this.channel);
        ((Channel)Mockito.doAnswer(arg_0 -> this.lambda$setUp$0((ChannelFuture)cfuture, arg_0)).when((Object)this.channel)).writeAndFlush(ArgumentMatchers.any(Notification.class));
        ((Channel)Mockito.doReturn((Object)this.channelFuture).when((Object)this.channel)).closeFuture();
        ((ChannelFuture)Mockito.doReturn((Object)this.channelFuture).when((Object)this.channelFuture)).addListener((GenericFutureListener)ArgumentMatchers.any(GenericFutureListener.class));
        ((Channel)Mockito.doReturn((Object)"TestingChannel").when((Object)this.channel)).toString();
        ((Channel)Mockito.doReturn((Object)this.pipeline).when((Object)this.channel)).pipeline();
        ((Channel)Mockito.doReturn((Object)this.address).when((Object)this.channel)).localAddress();
        ((Channel)Mockito.doReturn((Object)this.address).when((Object)this.channel)).remoteAddress();
        ((Channel)Mockito.doReturn((Object)this.eventLoop).when((Object)this.channel)).eventLoop();
        ((ScheduledFuture)Mockito.doReturn((Object)true).when(this.future)).cancel(false);
        ((EventLoop)Mockito.doReturn(this.future).when((Object)this.eventLoop)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ((Long)ArgumentMatchers.any(Long.TYPE)).longValue(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        ((ChannelPipeline)Mockito.doReturn((Object)this.pipeline).when((Object)this.pipeline)).replace((ChannelHandler)ArgumentMatchers.any(ChannelHandler.class), (String)ArgumentMatchers.any(String.class), (ChannelHandler)ArgumentMatchers.any(ChannelHandler.class));
        ((ChannelPipeline)Mockito.doReturn((Object)this.pipeline).when((Object)this.pipeline)).addFirst(new ChannelHandler[]{(ChannelHandler)ArgumentMatchers.any(ChannelHandler.class)});
        ((Channel)Mockito.doReturn((Object)true).when((Object)this.channel)).isActive();
        ((Channel)Mockito.doReturn((Object)Mockito.mock(ChannelFuture.class)).when((Object)this.channel)).close();
        ((Channel)Mockito.doReturn((Object)new InetSocketAddress(this.ipAddress, this.port)).when((Object)this.channel)).remoteAddress();
        ((Channel)Mockito.doReturn((Object)new InetSocketAddress(this.ipAddress, this.port)).when((Object)this.channel)).localAddress();
        this.openMsg = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.OpenBuilder().setOpenMessage(new OpenMessageBuilder().setOpen(new OpenBuilder().setDeadTimer(DEADTIMER).setKeepalive(KEEP_ALIVE).setSessionId(Uint8.ZERO).build()).build()).build();
        this.kaMsg = new KeepaliveBuilder().setKeepaliveMessage(new KeepaliveMessageBuilder().build()).build();
        this.startTlsMsg = new StarttlsBuilder().setStartTlsMessage(new StartTlsMessageBuilder().build()).build();
        this.closeMsg = new CloseBuilder().setCCloseMessage(new CCloseMessageBuilder().setCClose(new CCloseBuilder().setReason(Uint8.valueOf((int)6)).build()).build()).build();
        this.listener = new SimpleSessionListener();
    }

    private /* synthetic */ Object lambda$setUp$0(ChannelFuture cfuture, InvocationOnMock invocation) throws Throwable {
        Object[] args = invocation.getArguments();
        this.msgsSend.add((Notification)args[0]);
        return cfuture;
    }
}

