/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.protocol.concepts.KeyMapping;
import org.opendaylight.protocol.pcep.MessageRegistry;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.PCEPTimerProposal;
import org.opendaylight.protocol.pcep.impl.DefaultPCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.impl.PCEPDispatcherImpl;
import org.opendaylight.protocol.pcep.impl.PCEPHandlerFactory;
import org.opendaylight.protocol.pcep.impl.PCEPProtocolSessionPromise;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.protocol.pcep.impl.SimpleSessionListener;
import org.opendaylight.protocol.pcep.spi.pojo.DefaultPCEPExtensionConsumerContext;
import org.opendaylight.protocol.util.InetSocketAddressUtil;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class PCEPDispatcherImplTest {
    private static final @NonNull Uint8 DEAD_TIMER = Uint8.valueOf((int)120);
    private static final @NonNull Uint8 KEEP_ALIVE = Uint8.valueOf((int)30);
    private static final int RETRY_TIMER = 0;
    private static final int CONNECT_TIMEOUT = 500;
    private PCEPDispatcherImpl dispatcher;
    private PCEPDispatcherImpl disp2Spy;
    @Mock
    private java.nio.channels.Channel mockChannel;
    private MessageRegistry msgReg;
    private PCEPSessionNegotiatorFactory negotiatorFactory;
    private PCCMock pccMock;

    @Before
    public void setUp() {
        this.msgReg = new DefaultPCEPExtensionConsumerContext().getMessageHandlerRegistry();
        this.negotiatorFactory = new DefaultPCEPSessionNegotiatorFactory(SimpleSessionListener::new, new PCEPTimerProposal(KEEP_ALIVE, DEAD_TIMER), List.of(), Uint16.ZERO, null);
        this.dispatcher = new PCEPDispatcherImpl();
        PCEPDispatcherImpl dispatcher2 = new PCEPDispatcherImpl();
        this.disp2Spy = (PCEPDispatcherImpl)Mockito.spy((Object)dispatcher2);
        this.pccMock = new PCCMock(this.negotiatorFactory, new PCEPHandlerFactory(this.msgReg));
    }

    @After
    public void tearDown() {
        this.dispatcher.close();
        this.disp2Spy.close();
    }

    @Test(timeout=20000L)
    public void testCreateClientServer() throws InterruptedException, ExecutionException {
        int port = InetSocketAddressUtil.getRandomPort();
        InetSocketAddress serverAddr = new InetSocketAddress("0.0.0.0", port);
        InetSocketAddress clientAddr1 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        InetSocketAddress clientAddr2 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        ChannelFuture futureChannel = this.dispatcher.createServer(serverAddr, KeyMapping.of(), this.msgReg, this.negotiatorFactory);
        futureChannel.sync();
        try (PCEPSessionImpl session1 = (PCEPSessionImpl)this.pccMock.createClient(clientAddr1, 0, 500).get();
             PCEPSessionImpl session2 = (PCEPSessionImpl)this.pccMock.createClient(clientAddr2, 0, 500).get();){
            Assert.assertTrue((boolean)futureChannel.channel().isActive());
            Assert.assertEquals((Object)clientAddr1.getAddress().getHostAddress(), (Object)session1.getPeerPref().getIpAddress());
            Assert.assertEquals((long)DEAD_TIMER.toJava(), (long)session1.getDeadTimerValue());
            Assert.assertEquals((long)KEEP_ALIVE.toJava(), (long)session1.getKeepAliveTimerValue());
            Assert.assertEquals((Object)clientAddr2.getAddress().getHostAddress(), (Object)session2.getPeerPref().getIpAddress());
            Assert.assertEquals((long)DEAD_TIMER.toJava(), (long)session2.getDeadTimerValue());
            Assert.assertEquals((long)KEEP_ALIVE.toJava(), (long)session2.getKeepAliveTimerValue());
        }
        Assert.assertTrue((boolean)futureChannel.channel().isActive());
    }

    @Test(timeout=20000L)
    public void testCreateDuplicateClient() throws InterruptedException, ExecutionException {
        int port = InetSocketAddressUtil.getRandomPort();
        InetSocketAddress serverAddr = new InetSocketAddress("0.0.0.0", port);
        InetSocketAddress clientAddr = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        this.dispatcher.createServer(serverAddr, KeyMapping.of(), this.msgReg, this.negotiatorFactory).sync();
        Future<PCEPSession> futureClient = this.pccMock.createClient(clientAddr, 0, 500);
        futureClient.sync();
        try (PCEPSession ignored = (PCEPSession)futureClient.get();){
            Throwable cause = ((ExecutionException)Assert.assertThrows(ExecutionException.class, () -> this.pccMock.createClient(clientAddr, 0, 500).get())).getCause();
            MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
            MatcherAssert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.startsWith((String)"A conflicting session for address "), CoreMatchers.endsWith((String)" found.")}));
        }
    }

    @Test(timeout=20000L)
    public void testReconnectClient() throws InterruptedException, ExecutionException {
        int port = InetSocketAddressUtil.getRandomPort();
        InetSocketAddress clientAddr = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        this.dispatcher.createServer(new InetSocketAddress("0.0.0.0", port), KeyMapping.of(), this.msgReg, this.negotiatorFactory).sync();
        PCEPSessionImpl session1 = (PCEPSessionImpl)this.pccMock.createClient(clientAddr, 0, 500).get();
        Assert.assertEquals((Object)clientAddr.getAddress(), (Object)session1.getRemoteAddress());
        Assert.assertEquals((long)DEAD_TIMER.toJava(), (long)session1.getDeadTimerValue());
        Assert.assertEquals((long)KEEP_ALIVE.toJava(), (long)session1.getKeepAliveTimerValue());
        session1.closeChannel().sync();
        try (PCEPSessionImpl session2 = (PCEPSessionImpl)this.pccMock.createClient(clientAddr, 0, 500).get();){
            Assert.assertEquals((Object)clientAddr.getAddress(), (Object)session1.getRemoteAddress());
            Assert.assertEquals((long)DEAD_TIMER.toJava(), (long)session2.getDeadTimerValue());
            Assert.assertEquals((long)KEEP_ALIVE.toJava(), (long)session2.getKeepAliveTimerValue());
        }
    }

    @Test(timeout=20000L)
    public void testCustomizeBootstrap() throws InterruptedException {
        int port = InetSocketAddressUtil.getRandomPort();
        InetSocketAddress clientAddr1 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        InetSocketAddress clientAddr2 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress((int)port);
        KeyMapping keys = KeyMapping.of(Map.of(clientAddr1.getAddress(), "CLIENT1_ADDRESS", clientAddr2.getAddress(), "CLIENT2_ADDRESS"));
        ChannelFuture futureChannel = this.disp2Spy.createServer(new InetSocketAddress("0.0.0.0", port), keys, this.msgReg, this.negotiatorFactory).sync();
        ((PCEPDispatcherImpl)Mockito.verify((Object)this.disp2Spy)).createServerBootstrap((PCEPDispatcherImpl.ChannelPipelineInitializer)ArgumentMatchers.any(PCEPDispatcherImpl.ChannelPipelineInitializer.class), (KeyMapping)ArgumentMatchers.same((Object)keys));
    }

    private static class PCCMock {
        private final PCEPSessionNegotiatorFactory negotiatorFactory;
        private final PCEPHandlerFactory factory;
        private final EventExecutor executor;
        private final EventLoopGroup workerGroup = new NioEventLoopGroup();

        PCCMock(PCEPSessionNegotiatorFactory negotiatorFactory, PCEPHandlerFactory factory) {
            this.negotiatorFactory = Objects.requireNonNull(negotiatorFactory);
            this.factory = Objects.requireNonNull(factory);
            this.executor = (EventExecutor)Objects.requireNonNull(GlobalEventExecutor.INSTANCE);
        }

        Future<PCEPSession> createClient(InetSocketAddress address, int retryTimer, int connectTimeout) {
            return this.createClient(address, retryTimer, connectTimeout, (ch, promise) -> {
                ch.pipeline().addLast(this.factory.getDecoders());
                ch.pipeline().addLast("negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator((Channel)ch, promise));
                ch.pipeline().addLast(this.factory.getEncoders());
            });
        }

        Future<PCEPSession> createClient(InetSocketAddress address, int retryTimer, int connectTimeout, final PCEPDispatcherImpl.ChannelPipelineInitializer initializer) {
            Bootstrap b = new Bootstrap();
            final PCEPProtocolSessionPromise p = new PCEPProtocolSessionPromise(this.executor, address, retryTimer, connectTimeout, b);
            ((Bootstrap)b.option(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    initializer.initializeChannel(ch, (Promise)p);
                }
            });
            this.setWorkerGroup(b);
            PCCMock.setChannelFactory(b);
            p.connect();
            return p;
        }

        private static void setChannelFactory(Bootstrap bootstrap) {
            try {
                bootstrap.channel(NioSocketChannel.class);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        private void setWorkerGroup(Bootstrap bootstrap) {
            if (bootstrap.config().group() == null) {
                bootstrap.group(this.workerGroup);
            }
        }
    }
}

