/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.channel.Channel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.TerminationReason;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionTest;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.protocol.pcep.impl.SimpleSessionListener;
import org.opendaylight.protocol.pcep.impl.spi.Util;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcerr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcreq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcreqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.CloseMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.Uint8;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class PCEPSessionImplTest
extends AbstractPCEPSessionTest {
    private PCEPSessionImpl session;

    @Before
    public void setup() {
        this.session = new PCEPSessionImpl((PCEPSessionListener)this.listener, 0, this.channel, this.openMsg.getOpenMessage().getOpen(), this.openMsg.getOpenMessage().getOpen());
        this.session.sessionUp();
    }

    @After
    public void tearDown() {
        this.session.close();
    }

    @Test
    public void testPcepSessionImpl() {
        Assert.assertTrue((boolean)this.listener.up);
        this.session.handleMessage((Message)this.kaMsg);
        Assert.assertEquals((long)1L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        this.session.handleMessage((Message)new PcreqBuilder().build());
        Assert.assertEquals((long)2L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        Assert.assertEquals((long)1L, (long)this.listener.messages.size());
        MatcherAssert.assertThat((Object)this.listener.messages.get(0), (Matcher)CoreMatchers.instanceOf(Pcreq.class));
        Assert.assertEquals((long)2L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        this.session.handleMessage((Message)this.closeMsg);
        Assert.assertEquals((long)3L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        Assert.assertEquals((long)1L, (long)this.listener.messages.size());
        Assert.assertTrue((boolean)this.channel.isActive());
        ((Channel)Mockito.verify((Object)this.channel)).close();
    }

    @Test
    public void testAttemptSecondSession() {
        this.session.handleMessage((Message)this.openMsg);
        Assert.assertEquals((long)1L, (long)this.session.getMessages().getReceivedMsgCount().intValue());
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Notification pcErr = (Notification)this.msgsSend.get(0);
        MatcherAssert.assertThat((Object)pcErr, (Matcher)CoreMatchers.instanceOf(Pcerr.class));
        ErrorObject errorObj = ((Errors)((Pcerr)pcErr).getPcerrMessage().getErrors().get(0)).getErrorObject();
        Assert.assertEquals((Object)PCEPErrors.ATTEMPT_2ND_SESSION, (Object)PCEPErrors.forValue((Uint8)errorObj.getType(), (Uint8)errorObj.getValue()));
    }

    @Test
    public void testClosedByNode() {
        this.session.handleMessage((Message)this.closeMsg);
        ((Channel)Mockito.verify((Object)this.channel)).close();
    }

    @Test
    public void testCapabilityNotSupported() {
        this.session.handleMalformedMessage(PCEPErrors.CAPABILITY_NOT_SUPPORTED);
        Assert.assertEquals((long)2L, (long)this.msgsSend.size());
        Notification pcErr = (Notification)this.msgsSend.get(0);
        MatcherAssert.assertThat((Object)pcErr, (Matcher)CoreMatchers.instanceOf(Pcerr.class));
        ErrorObject errorObj = ((Errors)((Pcerr)pcErr).getPcerrMessage().getErrors().get(0)).getErrorObject();
        Assert.assertEquals((Object)PCEPErrors.CAPABILITY_NOT_SUPPORTED, (Object)PCEPErrors.forValue((Uint8)errorObj.getType(), (Uint8)errorObj.getValue()));
        Assert.assertEquals((long)1L, (long)this.session.getMessages().getUnknownMsgReceived().intValue());
        Notification closeMsg = (Notification)this.msgsSend.get(1);
        MatcherAssert.assertThat((Object)closeMsg, (Matcher)CoreMatchers.instanceOf(CloseMessage.class));
        Assert.assertEquals((Object)TerminationReason.TOO_MANY_UNKNOWN_MSGS, (Object)TerminationReason.forValue((Uint8)((CloseMessage)closeMsg).getCCloseMessage().getCClose().getReason()));
        ((Channel)Mockito.verify((Object)this.channel)).close();
    }

    @Test
    public void testEndoOfInput() {
        Assert.assertTrue((boolean)this.listener.up);
        this.session.endOfInput();
        Assert.assertFalse((boolean)this.listener.up);
    }

    @Test
    public void testCloseSessionWithReason() {
        this.session.close(TerminationReason.UNKNOWN);
        Assert.assertEquals((long)1L, (long)this.msgsSend.size());
        Notification closeMsg = (Notification)this.msgsSend.get(0);
        MatcherAssert.assertThat((Object)closeMsg, (Matcher)CoreMatchers.instanceOf(CloseMessage.class));
        Assert.assertEquals((Object)TerminationReason.UNKNOWN, (Object)TerminationReason.forValue((Uint8)((CloseMessage)closeMsg).getCCloseMessage().getCClose().getReason()));
        ((Channel)Mockito.verify((Object)this.channel)).close();
    }

    @Test
    public void testSessionStatistics() {
        this.session.handleMessage((Message)Util.createErrorMessage((PCEPErrors)PCEPErrors.LSP_RSVP_ERROR, null));
        Assert.assertEquals((Object)this.ipAddress, (Object)this.session.getPeerPref().getIpAddress());
        PeerPref peerPref = this.session.getPeerPref();
        Assert.assertEquals((Object)this.ipAddress, (Object)peerPref.getIpAddress());
        Assert.assertEquals((Object)DEADTIMER, (Object)peerPref.getDeadtimer());
        Assert.assertEquals((Object)KEEP_ALIVE, (Object)peerPref.getKeepalive());
        Assert.assertEquals((long)0L, (long)peerPref.getSessionId().intValue());
        LocalPref localPref = this.session.getLocalPref();
        Assert.assertEquals((Object)this.ipAddress, (Object)localPref.getIpAddress());
        Assert.assertEquals((Object)DEADTIMER, (Object)localPref.getDeadtimer());
        Assert.assertEquals((Object)KEEP_ALIVE, (Object)localPref.getKeepalive());
        Assert.assertEquals((long)0L, (long)localPref.getSessionId().intValue());
        Messages msgs = this.session.getMessages();
        Assert.assertEquals((long)1L, (long)msgs.getReceivedMsgCount().longValue());
        Assert.assertEquals((long)0L, (long)msgs.getSentMsgCount().longValue());
        Assert.assertEquals((long)0L, (long)msgs.getUnknownMsgReceived().longValue());
        ErrorMessages errMsgs = msgs.getErrorMessages();
        Assert.assertEquals((long)1L, (long)errMsgs.getReceivedErrorMsgCount().intValue());
        Assert.assertEquals((long)0L, (long)errMsgs.getSentErrorMsgCount().intValue());
        Assert.assertEquals((Object)PCEPErrors.LSP_RSVP_ERROR.getErrorType(), (Object)errMsgs.getLastReceivedError().getErrorType());
        Assert.assertEquals((Object)PCEPErrors.LSP_RSVP_ERROR.getErrorValue(), (Object)errMsgs.getLastReceivedError().getErrorValue());
        this.session.sendMessage((Message)Util.createErrorMessage((PCEPErrors)PCEPErrors.UNKNOWN_PLSP_ID, null));
        Messages msgs2 = this.session.getMessages();
        Assert.assertEquals((long)1L, (long)msgs2.getReceivedMsgCount().longValue());
        Assert.assertEquals((long)1L, (long)msgs2.getSentMsgCount().longValue());
        Assert.assertEquals((long)0L, (long)msgs2.getUnknownMsgReceived().longValue());
        ErrorMessages errMsgs2 = msgs2.getErrorMessages();
        Assert.assertEquals((long)1L, (long)errMsgs2.getReceivedErrorMsgCount().intValue());
        Assert.assertEquals((long)1L, (long)errMsgs2.getSentErrorMsgCount().intValue());
        Assert.assertEquals((Object)PCEPErrors.UNKNOWN_PLSP_ID.getErrorType(), (Object)errMsgs2.getLastSentError().getErrorType());
        Assert.assertEquals((Object)PCEPErrors.UNKNOWN_PLSP_ID.getErrorValue(), (Object)errMsgs2.getLastSentError().getErrorValue());
    }

    @Test
    public void testExceptionCaught() {
        Assert.assertFalse((boolean)this.session.isClosed());
        Assert.assertTrue((boolean)this.listener.up);
        this.session.exceptionCaught(null, new Throwable("PCEP exception."));
        Assert.assertFalse((boolean)this.listener.up);
        Assert.assertTrue((boolean)this.session.isClosed());
    }

    @Test
    public void testSessionRecoveryOnException() {
        this.listener = new SimpleExceptionSessionListener();
        this.session = (PCEPSessionImpl)Mockito.spy((Object)new PCEPSessionImpl((PCEPSessionListener)this.listener, 0, this.channel, this.openMsg.getOpenMessage().getOpen(), this.openMsg.getOpenMessage().getOpen()));
        ((PCEPSessionImpl)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).handleException((Throwable)ArgumentMatchers.any());
        ((PCEPSessionImpl)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).sendMessage((Message)ArgumentMatchers.any());
        ((PCEPSessionImpl)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).closeChannel();
        UnsupportedOperationException ex = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> ((PCEPSessionImpl)this.session).sessionUp());
        Assert.assertEquals((Object)"Mocked runtime exception.", (Object)ex.getMessage());
        Assert.assertFalse((boolean)this.listener.up);
        ((PCEPSessionImpl)Mockito.verify((Object)this.session)).handleException((Throwable)ArgumentMatchers.any());
        ((PCEPSessionImpl)Mockito.verify((Object)this.session)).sendMessage((Message)ArgumentMatchers.any(CloseMessage.class));
        ((PCEPSessionImpl)Mockito.verify((Object)this.session)).closeChannel();
    }

    private static final class SimpleExceptionSessionListener
    extends SimpleSessionListener {
        private SimpleExceptionSessionListener() {
        }

        @Override
        public synchronized void onSessionUp(PCEPSession session) {
            super.onSessionUp(session);
            throw new UnsupportedOperationException("Mocked runtime exception.");
        }
    }
}

