/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationActivator;
import org.opendaylight.protocol.pcep.impl.TestVendorInformationTlvParser;
import org.opendaylight.protocol.pcep.parser.BaseParserExtensionActivator;
import org.opendaylight.protocol.pcep.parser.message.PCEPCloseMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPErrorMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPKeepAliveMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPMonitoringReplyMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPMonitoringRequestMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPNotificationMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPOpenMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPReplyMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPRequestMessageParser;
import org.opendaylight.protocol.pcep.parser.message.PCEPStartTLSMessageParser;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.spi.pojo.SimplePCEPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.CloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.KeepaliveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcerrBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcmonrepBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcmonreqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcntfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcrepBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcreqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.StarttlsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.BandwidthBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.object.BranchNodeType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.object.branch.node.type.BranchNodeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.branch.node.object.BranchNodeListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.message.CCloseMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.object.CCloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.Ipv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.P2mpIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv4._case.Ipv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case.P2mpIpv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.EroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.IroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.keepalive.message.KeepaliveMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.LspaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.MetricBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.MonitoringBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.MonitoringMetricsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.GeneralMetricsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.SpecificMetricsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.specific.metrics.list.SpecificMetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.CNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.CNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.OfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.message.OpenMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.Overload;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.OverloadBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.ErrorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.RequestCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.SessionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.request._case.RequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.session._case.SessionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcmonrep.message.PcmonrepMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.PcntfMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.Notifications;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.NotificationsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.Rps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.notifications.RpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.PcrepMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.Replies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.RepliesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.Result;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.FailureCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.SuccessCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.NoPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.NoPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.success._case.SuccessBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.success._case.success.Paths;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.success._case.success.PathsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.MonitoringRequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.RequestsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.SvecBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.monitoring.request.PceIdList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.monitoring.request.PceIdListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2pBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPairBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.IroBncChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.RrosBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.rros.RouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.rros.route.object.ReportedRouteObjectCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.rros.route.object.SecondaryReportedRouteObjectCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.iro.bnc.choice.BncCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTimeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.RroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.RpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.reported.route.object.SrroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.start.tls.message.StartTlsMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumberBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

public class PCEPValidatorTest {
    private ObjectRegistry objectRegistry;
    private Open open;
    private Rp rpTrue;
    private Rp rpFalse;
    private NoPath noPath;
    private Lspa lspa;
    private Metrics metrics;
    private Iro iro;
    private Ero ero;
    private Of of;
    private EndpointsObj endpoints;
    private Svec svec;
    private List<VendorInformationObject> viObjects;
    private Monitoring monitoring;
    private PccIdReq pccIdReq;
    private PceId pceId;
    private ProcTime procTime;
    private Overload overload;
    private AsNumberCase eroASSubobject;
    private SimplePCEPExtensionProviderContext ctx;
    private BaseParserExtensionActivator act;
    private TestVendorInformationActivator viObjAct;

    @Before
    public void setUp() {
        this.ctx = new SimplePCEPExtensionProviderContext();
        this.act = new BaseParserExtensionActivator();
        this.viObjAct = new TestVendorInformationActivator();
        this.act.start((PCEPExtensionProviderContext)this.ctx);
        this.viObjAct.start((PCEPExtensionProviderContext)this.ctx);
        this.objectRegistry = this.ctx.getObjectHandlerRegistry();
        RpBuilder rpBuilder = new RpBuilder().setProcessingRule(Boolean.valueOf(true)).setIgnore(Boolean.valueOf(false)).setReoptimization(Boolean.valueOf(false)).setBiDirectional(Boolean.valueOf(false)).setLoose(Boolean.valueOf(true)).setMakeBeforeBreak(Boolean.valueOf(false)).setOrder(Boolean.valueOf(false)).setPathKey(Boolean.valueOf(false)).setSupplyOf(Boolean.valueOf(false)).setFragmentation(Boolean.valueOf(false)).setP2mp(Boolean.valueOf(false)).setEroCompression(Boolean.valueOf(false)).setPriority(Uint8.ONE).setRequestId(new RequestId(Uint32.TEN)).setTlvs(new TlvsBuilder().build());
        this.rpTrue = rpBuilder.build();
        this.rpFalse = rpBuilder.setProcessingRule(Boolean.valueOf(false)).build();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder openBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder().setProcessingRule(Boolean.valueOf(false)).setIgnore(Boolean.valueOf(false)).setDeadTimer(Uint8.ONE).setKeepalive(Uint8.ONE).setSessionId(Uint8.ZERO).setVersion(new ProtocolVersion(Uint8.ONE)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.TlvsBuilder().build());
        this.open = openBuilder.build();
        this.noPath = new NoPathBuilder().setProcessingRule(Boolean.valueOf(false)).setIgnore(Boolean.valueOf(false)).setNatureOfIssue(Uint8.ZERO).setUnsatisfiedConstraints(Boolean.valueOf(false)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.TlvsBuilder().build()).build();
        this.lspa = new LspaBuilder().setProcessingRule(Boolean.valueOf(false)).setIgnore(Boolean.valueOf(false)).setLocalProtectionDesired(Boolean.valueOf(false)).setHoldPriority(Uint8.ZERO).setSetupPriority(Uint8.ZERO).setExcludeAny(new AttributeFilter(Uint32.ZERO)).setIncludeAll(new AttributeFilter(Uint32.ZERO)).setIncludeAny(new AttributeFilter(Uint32.ZERO)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.lspa.TlvsBuilder().build()).build();
        this.metrics = new MetricsBuilder().setMetric(new MetricBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setComputed(Boolean.valueOf(false)).setBound(Boolean.valueOf(false)).setMetricType(Uint8.ONE).setValue(new Float32(new byte[4])).build()).build();
        this.eroASSubobject = new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)65535))).build()).build();
        IroBuilder iroBuilder = new IroBuilder();
        iroBuilder.setIgnore(Boolean.valueOf(false));
        iroBuilder.setProcessingRule(Boolean.valueOf(false));
        ArrayList<Subobject> iroSubs = new ArrayList<Subobject>();
        iroSubs.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.SubobjectBuilder().setSubobjectType((SubobjectType)this.eroASSubobject).setLoose(Boolean.valueOf(false)).build());
        iroBuilder.setSubobject(iroSubs);
        this.iro = iroBuilder.build();
        EroBuilder eroBuilder = new EroBuilder();
        eroBuilder.setIgnore(Boolean.valueOf(false));
        eroBuilder.setProcessingRule(Boolean.valueOf(false));
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject> eroSubs = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject>();
        eroSubs.add(new SubobjectBuilder().setSubobjectType((SubobjectType)this.eroASSubobject).setLoose(Boolean.valueOf(false)).build());
        eroBuilder.setSubobject(eroSubs);
        this.ero = eroBuilder.build();
        this.of = new OfBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setCode(new OfId(Uint16.ZERO)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.of.TlvsBuilder().build()).build();
        this.endpoints = new EndpointsObjBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(true)).setAddressFamily((AddressFamily)new Ipv4CaseBuilder().setIpv4(new Ipv4Builder().setSourceIpv4Address(new Ipv4AddressNoZone("255.255.255.255")).setDestinationIpv4Address(new Ipv4AddressNoZone("255.255.255.255")).build()).build()).build();
        this.svec = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.SvecBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setLinkDiverse(Boolean.valueOf(false)).setNodeDiverse(Boolean.valueOf(false)).setSrlgDiverse(Boolean.valueOf(false)).setLinkDirectionDiverse(Boolean.valueOf(false)).setPartialPathDiverse(Boolean.valueOf(false)).setRequestsIds(Set.of(new RequestId(Uint32.ONE))).build();
        this.viObjects = new ArrayList<VendorInformationObject>();
        TestVendorInformationTlvParser.TestEnterpriseSpecificInformation esInfo = new TestVendorInformationTlvParser.TestEnterpriseSpecificInformation(5);
        VendorInformationObject viObj = new VendorInformationObjectBuilder().setEnterpriseNumber(new EnterpriseNumber(Uint32.ZERO)).setEnterpriseSpecificInformation((EnterpriseSpecificInformation)esInfo).build();
        this.viObjects.add(viObj);
        this.monitoring = new MonitoringBuilder().setMonitoringId(Uint32.valueOf((int)100)).setFlags(new Monitoring.Flags(false, false, false, false, false)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.monitoring.TlvsBuilder().build()).build();
        this.pccIdReq = new PccIdReqBuilder().setIpAddress(new IpAddressNoZone(new Ipv4AddressNoZone("127.0.0.1"))).build();
        this.pceId = new PceIdBuilder().setIpAddress(new IpAddressNoZone(new Ipv4AddressNoZone("127.0.0.2"))).build();
        this.procTime = new ProcTimeBuilder().setEstimated(Boolean.valueOf(false)).setCurrentProcTime(Uint32.ONE).setMinProcTime(Uint32.TWO).setMaxProcTime(Uint32.valueOf((int)3)).setAverageProcTime(Uint32.valueOf((int)4)).setVarianceProcTime(Uint32.valueOf((int)5)).build();
        this.overload = new OverloadBuilder().setDuration(Uint16.valueOf((int)120)).build();
    }

    @Test
    public void testOpenMsg() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPOpenMessage1.bin"));
        PCEPOpenMessageParser parser = new PCEPOpenMessageParser(this.ctx.getObjectHandlerRegistry());
        OpenMessageBuilder builder = new OpenMessageBuilder();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder b = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder().setProcessingRule(Boolean.valueOf(false)).setIgnore(Boolean.valueOf(false)).setVersion(new ProtocolVersion(Uint8.ONE)).setKeepalive(Uint8.valueOf((int)30)).setDeadTimer(Uint8.valueOf((int)120)).setSessionId(Uint8.ONE).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.TlvsBuilder().build());
        builder.setOpen(b.build());
        Assert.assertEquals((Object)new OpenBuilder().setOpenMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new OpenBuilder().setOpenMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new OpenBuilder().setOpenMessage(new OpenMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Open Object must be present in Open Message.", (Object)e.getMessage());
        }
    }

    @Test
    public void testKeepAliveMsg() throws PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])new byte[]{32, 2, 0, 4});
        PCEPKeepAliveMessageParser parser = new PCEPKeepAliveMessageParser(this.objectRegistry);
        KeepaliveBuilder builder = new KeepaliveBuilder().setKeepaliveMessage(new KeepaliveMessageBuilder().build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testStartTLSMsg() throws Exception {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])new byte[]{32, 20, 0, 4});
        PCEPStartTLSMessageParser parser = new PCEPStartTLSMessageParser(this.objectRegistry);
        StarttlsBuilder builder = new StarttlsBuilder().setStartTlsMessage(new StartTlsMessageBuilder().build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testCloseMsg() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPCloseMessage1.bin"));
        PCEPCloseMessageParser parser = new PCEPCloseMessageParser(this.objectRegistry);
        CloseBuilder builder = new CloseBuilder().setCCloseMessage(new CCloseMessageBuilder().setCClose(new CCloseBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setReason(Uint8.valueOf((int)5)).setTlvs(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.object.c.close.TlvsBuilder().build()).build()).build());
        Assert.assertEquals((Object)builder.build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)builder.build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new CloseBuilder().setCCloseMessage(new CCloseMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Close Object must be present in Close Message.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRequestMsg() throws IOException, PCEPDeserializerException {
        PCEPRequestMessageParser parser = new PCEPRequestMessageParser(this.objectRegistry);
        PcreqMessageBuilder builder = new PcreqMessageBuilder();
        ArrayList<Requests> reqs1 = new ArrayList<Requests>();
        RequestsBuilder rBuilder = new RequestsBuilder();
        rBuilder.setRp(this.rpTrue);
        rBuilder.setSegmentComputation(new SegmentComputationBuilder().setP2p(new P2pBuilder().setEndpointsObj(this.endpoints).build()).build());
        reqs1.add(rBuilder.build());
        builder.setRequests(reqs1);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCEPRequestMessage1.bin"));
        Assert.assertEquals((Object)new PcreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCReq.3.bin"));
        ArrayList<Requests> reqs2 = new ArrayList<Requests>();
        RequestsBuilder rBuilder1 = new RequestsBuilder();
        rBuilder1.setRp(this.rpTrue);
        P2pBuilder p2pBuilder = new P2pBuilder().setEndpointsObj(this.endpoints).setMetrics(List.of(this.metrics)).setIro(this.iro);
        rBuilder1.setSegmentComputation(new SegmentComputationBuilder().setP2p(p2pBuilder.build()).build());
        reqs2.add(rBuilder1.build());
        builder.setRequests(reqs2).setSvec(List.of(new SvecBuilder().setSvec(this.svec).build()));
        Assert.assertEquals((Object)new PcreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCReq.9.bin"));
        ArrayList<Requests> reqs3 = new ArrayList<Requests>();
        RequestsBuilder rBuilder2 = new RequestsBuilder();
        rBuilder2.setRp(new RpBuilder(this.rpTrue).setP2mp(Boolean.valueOf(true)).build());
        EndpointsObjBuilder epBuilder = new EndpointsObjBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(true)).setAddressFamily((AddressFamily)new P2mpIpv4CaseBuilder().setP2mpIpv4(new P2mpIpv4Builder().setP2mpLeaves(P2mpLeaves.NewLeavesToAdd).setSourceIpv4Address(new Ipv4AddressNoZone("255.255.255.255")).setDestinationIpv4Address((Set)ImmutableSet.of((Object)new Ipv4AddressNoZone("255.255.255.254"), (Object)new Ipv4AddressNoZone("255.255.255.253"))).build()).build());
        P2mpBuilder p2mpBuilder = new P2mpBuilder();
        p2mpBuilder.setEndpointRroPair(List.of(new EndpointRroPairBuilder().setEndpointsObj(epBuilder.build()).setRros(List.of(new RrosBuilder().setRouteObject((RouteObject)new ReportedRouteObjectCaseBuilder().setRro(new RroBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(true)).setSubobject(List.of(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder().setProtectionAvailable(Boolean.valueOf(false)).setProtectionInUse(Boolean.valueOf(false)).setSubobjectType((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.252/32"))).build()).build()).build())).build()).build()).build(), new RrosBuilder().setRouteObject((RouteObject)new SecondaryReportedRouteObjectCaseBuilder().setSrro(new SrroBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(true)).setSubobject(List.of(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.reported.route.object.srro.SubobjectBuilder().setProtectionInUse(Boolean.valueOf(false)).setProtectionAvailable(Boolean.valueOf(false)).setSubobjectType((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.251/32"))).build()).build()).build())).build()).build()).build())).build()));
        p2mpBuilder.setIroBncChoice((IroBncChoice)new BncCaseBuilder().setBranchNodeType((BranchNodeType)new BranchNodeCaseBuilder().setBranchNodeList(new BranchNodeListBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(true)).setSubobject(List.of(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.SubobjectBuilder().setLoose(Boolean.valueOf(false)).setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.252/32"))).build())).build()).build()).build());
        rBuilder2.setSegmentComputation(new SegmentComputationBuilder().setP2mp(p2mpBuilder.build()).build());
        reqs3.add(rBuilder2.build());
        builder.setRequests(reqs3).setSvec(null);
        Assert.assertEquals((Object)new PcreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(new PcreqMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Requests cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(new PcreqMessageBuilder().setRequests(List.of()).build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Requests cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testReplyMsg() throws IOException, PCEPDeserializerException {
        PCEPReplyMessageParser parser = new PCEPReplyMessageParser(this.objectRegistry);
        PcrepMessageBuilder builder = new PcrepMessageBuilder();
        RepliesBuilder repliesBuilder = new RepliesBuilder();
        ArrayList<Replies> replies1 = new ArrayList<Replies>();
        repliesBuilder.setRp(this.rpTrue);
        replies1.add(repliesBuilder.build());
        builder.setReplies(replies1);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.1.bin"));
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.2.bin"));
        ArrayList<Replies> replies2 = new ArrayList<Replies>();
        repliesBuilder = new RepliesBuilder();
        repliesBuilder.setRp(this.rpTrue);
        replies2.add(repliesBuilder.build());
        RepliesBuilder repliesBuilder2 = new RepliesBuilder();
        repliesBuilder2.setRp(this.rpTrue);
        repliesBuilder2.setResult((Result)new FailureCaseBuilder().setNoPath(this.noPath).build());
        replies2.add(repliesBuilder2.build());
        builder.setReplies(replies2);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.3.bin"));
        ArrayList<Replies> replies3 = new ArrayList<Replies>();
        repliesBuilder = new RepliesBuilder();
        repliesBuilder.setRp(this.rpTrue);
        repliesBuilder.setResult((Result)new FailureCaseBuilder().setNoPath(this.noPath).setLspa(this.lspa).setMetrics(List.of(this.metrics)).setIro(this.iro).build());
        replies3.add(repliesBuilder.build());
        builder.setReplies(replies3);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.5.bin"));
        ArrayList<Replies> replies4 = new ArrayList<Replies>();
        repliesBuilder = new RepliesBuilder();
        repliesBuilder.setRp(this.rpTrue);
        ArrayList<Paths> paths = new ArrayList<Paths>();
        PathsBuilder paBuilder = new PathsBuilder().setEro(this.ero).setLspa(this.lspa).setMetrics(List.of(this.metrics)).setIro(this.iro).setOf(this.of);
        paths.add(paBuilder.build());
        repliesBuilder.setResult((Result)new SuccessCaseBuilder().setSuccess(new SuccessBuilder().setPaths(paths).build()).build()).build();
        replies4.add(repliesBuilder.build());
        builder.setReplies(replies4);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(new PcrepMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Replies cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(new PcrepMessageBuilder().setReplies(List.of()).build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Replies cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotificationMsg() throws IOException, PCEPDeserializerException {
        CNotification cn1 = new CNotificationBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setType(Uint8.ONE).setValue(Uint8.ONE).build();
        ArrayList<Notifications> innerNot = new ArrayList<Notifications>();
        innerNot.add(new NotificationsBuilder().setCNotification(cn1).build());
        ArrayList<Rps> rps = new ArrayList<Rps>();
        rps.add(new RpsBuilder().setRp(this.rpFalse).build());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCNtf.5.bin"));
        PCEPNotificationMessageParser parser = new PCEPNotificationMessageParser(this.objectRegistry);
        PcntfMessageBuilder builder = new PcntfMessageBuilder();
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.Notifications> nots = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.Notifications>();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.NotificationsBuilder b = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcntf.message.pcntf.message.NotificationsBuilder();
        b.setNotifications(innerNot);
        b.setRps(rps);
        nots.add(b.build());
        ArrayList<Notifications> innerNot1 = new ArrayList<Notifications>();
        innerNot1.add(new NotificationsBuilder().setCNotification(cn1).build());
        innerNot1.add(new NotificationsBuilder().setCNotification(cn1).build());
        ArrayList<Rps> rps1 = new ArrayList<Rps>();
        rps1.add(new RpsBuilder().setRp(this.rpFalse).build());
        rps1.add(new RpsBuilder().setRp(this.rpFalse).build());
        b.setNotifications(innerNot1);
        b.setRps(rps1);
        nots.add(b.build());
        builder.setNotifications(nots);
        Assert.assertEquals((Object)new PcntfBuilder().setPcntfMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcntfBuilder().setPcntfMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testErrorMsg() throws IOException, PCEPDeserializerException {
        ErrorObject error1 = new ErrorObjectBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setType(Uint8.valueOf((int)3)).setValue(Uint8.ONE).build();
        PCEPErrorMessageParser parser = new PCEPErrorMessageParser(this.ctx.getObjectHandlerRegistry());
        ArrayList<Errors> innerErr = new ArrayList<Errors>();
        PcerrMessageBuilder builder = new PcerrMessageBuilder();
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.request._case.request.Rps> rps = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.request._case.request.Rps>();
        rps.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.request._case.request.RpsBuilder().setRp(this.rpFalse).build());
        innerErr.add(new ErrorsBuilder().setErrorObject(error1).build());
        builder.setErrors(innerErr);
        builder.setErrorType((ErrorType)new RequestCaseBuilder().setRequest(new RequestBuilder().setRps(rps).build()).build());
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCErr.5.bin"));
        Assert.assertEquals((Object)new PcerrBuilder().setPcerrMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcerrBuilder().setPcerrMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCErr.3.bin"));
        error1 = new ErrorObjectBuilder().setIgnore(Boolean.valueOf(false)).setProcessingRule(Boolean.valueOf(false)).setType(Uint8.valueOf((int)3)).setValue(Uint8.ONE).build();
        innerErr = new ArrayList();
        innerErr.add(new ErrorsBuilder().setErrorObject(error1).build());
        builder.setErrors(innerErr);
        builder.setErrorType((ErrorType)new SessionCaseBuilder().setSession(new SessionBuilder().setOpen(this.open).build()).build());
        Assert.assertEquals((Object)new PcerrBuilder().setPcerrMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcerrBuilder().setPcerrMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        try {
            parser.serializeMessage((Message)new PcerrBuilder().setPcerrMessage(new PcerrMessageBuilder().build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Errors should not be empty.", (Object)e.getMessage());
        }
        try {
            parser.serializeMessage((Message)new PcerrBuilder().setPcerrMessage(new PcerrMessageBuilder().setErrors(List.of()).build()).build(), null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Errors should not be empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testReqMsgWithVendorInfoObjects() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCReq.7.bin"));
        PCEPRequestMessageParser parser = new PCEPRequestMessageParser(this.objectRegistry);
        PcreqMessageBuilder builder = new PcreqMessageBuilder();
        ArrayList<Requests> reqs1 = new ArrayList<Requests>();
        RequestsBuilder rBuilder = new RequestsBuilder();
        rBuilder.setRp(this.rpTrue);
        rBuilder.setVendorInformationObject(this.viObjects);
        SegmentComputationBuilder sBuilder = new SegmentComputationBuilder();
        sBuilder.setP2p(new P2pBuilder().setEndpointsObj(this.endpoints).setVendorInformationObject(this.viObjects).build());
        rBuilder.setSegmentComputation(sBuilder.build());
        reqs1.add(rBuilder.build());
        builder.setSvec(List.of(new SvecBuilder().setSvec(this.svec).setVendorInformationObject(this.viObjects).build()));
        builder.setRequests(reqs1);
        Assert.assertEquals((Object)new PcreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testRepMsgWithVendorInforObjects() throws IOException, PCEPDeserializerException {
        PCEPReplyMessageParser parser = new PCEPReplyMessageParser(this.objectRegistry);
        PcrepMessageBuilder builder = new PcrepMessageBuilder();
        RepliesBuilder repliesBuilder = new RepliesBuilder();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.6.bin"));
        ArrayList<Replies> replies = new ArrayList<Replies>();
        repliesBuilder = new RepliesBuilder().setRp(this.rpTrue).setVendorInformationObject(this.viObjects);
        ArrayList<Paths> paths = new ArrayList<Paths>();
        PathsBuilder paBuilder = new PathsBuilder();
        paBuilder.setEro(this.ero);
        paths.add(paBuilder.build());
        repliesBuilder.setResult((Result)new SuccessCaseBuilder().setSuccess(new SuccessBuilder().setPaths(paths).setVendorInformationObject(this.viObjects).build()).build()).build();
        replies.add(repliesBuilder.build());
        builder.setReplies(replies);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testMonRepMsg() throws PCEPDeserializerException, IOException {
        PCEPMonitoringReplyMessageParser parser = new PCEPMonitoringReplyMessageParser(this.objectRegistry);
        PcmonrepMessageBuilder builder = new PcmonrepMessageBuilder();
        builder.setMonitoring(this.monitoring).setMonitoringMetricsList((MonitoringMetricsList)new GeneralMetricsListBuilder().setMetricPce(List.of(new MetricPceBuilder().setPceId(this.pceId).build())).build());
        byte[] msgBytes = new byte[]{32, 9, 0, 24, 19, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 100, 25, 16, 0, 8, 127, 0, 0, 2};
        ByteBuf result = Unpooled.wrappedBuffer((byte[])msgBytes);
        Assert.assertEquals((Object)new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        builder.setMonitoring(this.monitoring);
        builder.setPccIdReq(this.pccIdReq);
        SpecificMetricsBuilder smBuilder = new SpecificMetricsBuilder();
        smBuilder.setRp(this.rpTrue);
        ArrayList<MetricPce> metricPces = new ArrayList<MetricPce>();
        metricPces.add(new MetricPceBuilder().setOverload(this.overload).setPceId(this.pceId).setProcTime(this.procTime).build());
        metricPces.add(new MetricPceBuilder().setPceId(this.pceId).setProcTime(this.procTime).build());
        smBuilder.setMetricPce(metricPces);
        SpecificMetricsBuilder smBuilder2 = new SpecificMetricsBuilder();
        ArrayList<MetricPce> metricPces2 = new ArrayList<MetricPce>();
        smBuilder2.setRp(this.rpTrue);
        metricPces2.add(new MetricPceBuilder().setOverload(this.overload).setPceId(this.pceId).build());
        smBuilder2.setMetricPce(metricPces2);
        builder.setMonitoringMetricsList((MonitoringMetricsList)new SpecificMetricsListBuilder().setSpecificMetrics(List.of(smBuilder.build(), smBuilder2.build())).build());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCMonRep.bin"));
        Assert.assertEquals((Object)new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testRepWithMonitoring() throws IOException, PCEPDeserializerException {
        PCEPReplyMessageParser parser = new PCEPReplyMessageParser(this.objectRegistry);
        PcrepMessageBuilder builder = new PcrepMessageBuilder();
        RepliesBuilder repliesBuilder = new RepliesBuilder();
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRepMon.5.bin"));
        ArrayList<Replies> replies4 = new ArrayList<Replies>();
        repliesBuilder = new RepliesBuilder().setRp(this.rpTrue).setMonitoring(this.monitoring).setPccIdReq(this.pccIdReq).setMetricPce(List.of(new MetricPceBuilder().setPceId(this.pceId).build()));
        ArrayList<Paths> paths = new ArrayList<Paths>();
        PathsBuilder paBuilder = new PathsBuilder().setEro(this.ero).setLspa(this.lspa).setMetrics(List.of(this.metrics)).setIro(this.iro).setOf(this.of);
        paths.add(paBuilder.build());
        repliesBuilder.setResult((Result)new SuccessCaseBuilder().setSuccess(new SuccessBuilder().setPaths(paths).build()).build()).build();
        replies4.add(repliesBuilder.build());
        builder.setReplies(replies4);
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testReqWithMonitoring() throws IOException, PCEPDeserializerException {
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCReq.8.bin"));
        PCEPRequestMessageParser parser = new PCEPRequestMessageParser(this.objectRegistry);
        PcreqMessageBuilder builder = new PcreqMessageBuilder();
        ArrayList<Requests> reqs1 = new ArrayList<Requests>();
        RequestsBuilder rBuilder = new RequestsBuilder();
        rBuilder.setRp(this.rpTrue).setSegmentComputation(new SegmentComputationBuilder().setP2p(new P2pBuilder().setEndpointsObj(this.endpoints).build()).build());
        reqs1.add(rBuilder.build());
        MonitoringRequestBuilder monReqBuilder = new MonitoringRequestBuilder().setMonitoring(this.monitoring).setPccIdReq(this.pccIdReq).setPceIdList(List.of(new PceIdListBuilder().setPceId(this.pceId).build()));
        builder.setMonitoringRequest(monReqBuilder.build()).setRequests(reqs1);
        Assert.assertEquals((Object)new PcreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testMonReqMsg() throws PCEPDeserializerException, IOException {
        PCEPMonitoringRequestMessageParser parser = new PCEPMonitoringRequestMessageParser(this.objectRegistry);
        PcreqMessageBuilder builder = new PcreqMessageBuilder();
        MonitoringRequestBuilder monReqBuilder = new MonitoringRequestBuilder().setMonitoring(this.monitoring).setPceIdList(List.of(new PceIdListBuilder().setPceId(this.pceId).build()));
        builder.setMonitoringRequest(monReqBuilder.build());
        byte[] msgBytes = new byte[]{32, 8, 0, 24, 19, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 100, 25, 16, 0, 8, 127, 0, 0, 2};
        ByteBuf result = Unpooled.wrappedBuffer((byte[])msgBytes);
        Assert.assertEquals((Object)new PcmonreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcmonreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
        result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCMonReq.bin"));
        ArrayList<Requests> reqs2 = new ArrayList<Requests>();
        RequestsBuilder rBuilder1 = new RequestsBuilder();
        rBuilder1.setRp(this.rpTrue);
        P2pBuilder p2pBuilder = new P2pBuilder().setEndpointsObj(this.endpoints).setMetrics(List.of(this.metrics)).setIro(this.iro);
        rBuilder1.setSegmentComputation(new SegmentComputationBuilder().setP2p(p2pBuilder.build()).build());
        reqs2.add(rBuilder1.build());
        builder.setRequests(reqs2).setSvec(List.of(new SvecBuilder().setSvec(this.svec).build()));
        monReqBuilder.setMonitoring(this.monitoring).setPccIdReq(this.pccIdReq);
        PceIdList pceIdList = new PceIdListBuilder().setPceId(this.pceId).build();
        monReqBuilder.setPceIdList(List.of(pceIdList, pceIdList));
        builder.setMonitoringRequest(monReqBuilder.build());
        Assert.assertEquals((Object)new PcmonreqBuilder().setPcreqMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcmonreqBuilder().setPcreqMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }

    @Test
    public void testReplyMsgWithTwoEros() throws IOException, PCEPDeserializerException {
        PCEPReplyMessageParser parser = new PCEPReplyMessageParser(this.objectRegistry);
        PcrepMessageBuilder builder = new PcrepMessageBuilder();
        ArrayList<Replies> replies = new ArrayList<Replies>();
        BandwidthBuilder bwBuilder = new BandwidthBuilder();
        bwBuilder.setIgnore(Boolean.valueOf(false));
        bwBuilder.setProcessingRule(Boolean.valueOf(false));
        bwBuilder.setBandwidth(new Bandwidth(new byte[]{71, 116, 36, 0}));
        RepliesBuilder repliesBuilder = new RepliesBuilder();
        repliesBuilder = new RepliesBuilder();
        repliesBuilder.setRp(this.rpTrue);
        ArrayList<Paths> paths = new ArrayList<Paths>();
        PathsBuilder paBuilder1 = new PathsBuilder().setEro(this.ero).setBandwidth(bwBuilder.build()).setMetrics(List.of(this.metrics));
        paths.add(paBuilder1.build());
        PathsBuilder paBuilder2 = new PathsBuilder();
        paBuilder2.setEro(this.ero);
        paths.add(paBuilder2.build());
        repliesBuilder.setResult((Result)new SuccessCaseBuilder().setSuccess(new SuccessBuilder().setPaths(paths).build()).build()).build();
        replies.add(repliesBuilder.build());
        builder.setReplies(replies);
        ByteBuf result = Unpooled.wrappedBuffer((byte[])ByteArray.fileToBytes((String)"src/test/resources/PCRep.7.bin"));
        Assert.assertEquals((Object)new PcrepBuilder().setPcrepMessage(builder.build()).build(), (Object)parser.parseMessage(result.slice(4, result.readableBytes() - 4), List.of()));
        ByteBuf buf = Unpooled.buffer((int)result.readableBytes());
        parser.serializeMessage((Message)new PcrepBuilder().setPcrepMessage(builder.build()).build(), buf);
        Assert.assertArrayEquals((byte[])result.array(), (byte[])buf.array());
    }
}

