/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.parser.BaseParserExtensionActivator;
import org.opendaylight.protocol.pcep.parser.subobject.EROAsNumberSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.EROExplicitExclusionRouteSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.EROIpv4PrefixSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.EROIpv6PrefixSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.EROLabelSubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.EROPathKey128SubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.EROPathKey32SubobjectParser;
import org.opendaylight.protocol.pcep.parser.subobject.EROUnnumberedInterfaceSubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.spi.pojo.SimplePCEPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.LabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumberBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.label._case.LabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.ExrsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.exrs._case.ExrsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.exrs._case.exrs.Exrs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.path.key._case.PathKeyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.GeneralizedLabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.generalized.label._case.GeneralizedLabelBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class PcepEROSubobjectParserTest {
    private static final byte[] IP4_PREFIX_BYTES = new byte[]{-127, 8, -1, -1, -1, -1, 22, 0};
    private static final byte[] IP6_PREFIX_BYTES = new byte[]{2, 20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, 0};
    private static final byte[] AS_NUMBER_BYTES = new byte[]{-96, 4, 0, 100};
    private static final byte[] UNNUMBERED_BYTES = new byte[]{-124, 12, 0, 0, 18, 52, 80, 0, -1, -1, -1, -1};
    private static final byte[] PATH_KEY32_BYTES = new byte[]{-64, 8, 18, 52, 18, 52, 80, 0};
    private static final byte[] PATH_KEY128_BYTES = new byte[]{-63, 20, 18, 52, 18, 52, 86, 120, -102, -68, -34, 18, 52, 84, 0, 0, 0, 0, 0, 0};
    private static final byte[] LABEL_BYTES = new byte[]{-125, 8, -128, 2, 18, 0, 37, -1};
    private static final byte[] EXRS_BYTES = new byte[]{-95, 6, -96, 4, 0, 100};
    private SimplePCEPExtensionProviderContext ctx;
    private BaseParserExtensionActivator act;

    @Before
    public void setUp() {
        this.ctx = new SimplePCEPExtensionProviderContext();
        this.act = new BaseParserExtensionActivator();
        this.act.start((PCEPExtensionProviderContext)this.ctx);
    }

    @Test
    public void testEROIp4PrefixSubobject() throws PCEPDeserializerException {
        EROIpv4PrefixSubobjectParser parser = new EROIpv4PrefixSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(new Ipv4Prefix("255.255.255.255/22"))).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])IP4_PREFIX_BYTES, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])IP4_PREFIX_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEROIp6PrefixSubobject() throws PCEPDeserializerException {
        EROIpv6PrefixSubobjectParser parser = new EROIpv6PrefixSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder().setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(new IpPrefixBuilder().setIpPrefix(new IpPrefix(Ipv6Util.prefixForBytes((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, (int)22))).build()).build()).setLoose(Boolean.valueOf(false));
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])IP6_PREFIX_BYTES, (int)2)), false));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])IP6_PREFIX_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEROAsNumberSubobject() throws PCEPDeserializerException {
        EROAsNumberSubobjectParser parser = new EROAsNumberSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)100))).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])AS_NUMBER_BYTES, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])AS_NUMBER_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEROUnnumberedSubobject() throws PCEPDeserializerException {
        EROUnnumberedInterfaceSubobjectParser parser = new EROUnnumberedInterfaceSubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(new UnnumberedBuilder().setRouterId(Uint32.valueOf((long)305418240L)).setInterfaceId(Uint32.valueOf((long)0xFFFFFFFFL)).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])UNNUMBERED_BYTES, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])UNNUMBERED_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Cannot be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEROPathKey32Subobject() throws PCEPDeserializerException {
        EROPathKey32SubobjectParser parser = new EROPathKey32SubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder().setLoose(Boolean.valueOf(true));
        PathKeyBuilder pBuilder = new PathKeyBuilder().setPceId(new PceId(new byte[]{18, 52, 80, 0})).setPathKey(new PathKey(Uint16.valueOf((int)4660)));
        subs.setSubobjectType((SubobjectType)new PathKeyCaseBuilder().setPathKey(pBuilder.build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])PATH_KEY32_BYTES, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])PATH_KEY32_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEROPathKey128Subobject() throws PCEPDeserializerException {
        EROPathKey128SubobjectParser parser = new EROPathKey128SubobjectParser();
        SubobjectBuilder subs = new SubobjectBuilder().setLoose(Boolean.valueOf(true));
        PathKeyBuilder pBuilder = new PathKeyBuilder().setPceId(new PceId(new byte[]{18, 52, 86, 120, -102, -68, -34, 18, 52, 84, 0, 0, 0, 0, 0, 0})).setPathKey(new PathKey(Uint16.valueOf((int)4660)));
        subs.setSubobjectType((SubobjectType)new PathKeyCaseBuilder().setPathKey(pBuilder.build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])PATH_KEY128_BYTES, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])PATH_KEY128_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEROLabelSubobject() throws Exception {
        EROLabelSubobjectParser parser = new EROLabelSubobjectParser(this.ctx.getLabelHandlerRegistry());
        SubobjectBuilder subs = new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new LabelCaseBuilder().setLabel(new LabelBuilder().setUniDirectional(Boolean.valueOf(true)).setLabelType((LabelType)new GeneralizedLabelCaseBuilder().setGeneralizedLabel(new GeneralizedLabelBuilder().setGeneralizedLabel(new byte[]{18, 0, 37, -1}).build()).build()).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])LABEL_BYTES, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])LABEL_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testERO_EXRSSubobject() throws Exception {
        EROExplicitExclusionRouteSubobjectParser parser = new EROExplicitExclusionRouteSubobjectParser(this.ctx.getXROSubobjectHandlerRegistry());
        ArrayList<Exrs> list = new ArrayList<Exrs>();
        list.add(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.exrs._case.exrs.ExrsBuilder().setMandatory(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new AsNumber(Uint32.valueOf((int)100))).build()).build()).build());
        SubobjectBuilder subs = new SubobjectBuilder().setLoose(Boolean.valueOf(true)).setSubobjectType((SubobjectType)new ExrsCaseBuilder().setExrs(new ExrsBuilder().setExrs(list).build()).build());
        Assert.assertEquals((Object)subs.build(), (Object)parser.parseSubobject(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])EXRS_BYTES, (int)2)), true));
        ByteBuf buff = Unpooled.buffer();
        parser.serializeSubobject(subs.build(), buff);
        Assert.assertArrayEquals((byte[])EXRS_BYTES, (byte[])ByteArray.getAllBytes((ByteBuf)buff));
        try {
            parser.parseSubobject(null, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
        try {
            parser.parseSubobject(Unpooled.EMPTY_BUFFER, true);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Array of bytes is mandatory. Can't be null or empty.", (Object)e.getMessage());
        }
    }
}

