/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.PCEPSessionImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepSessionTls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

public final class DefaultPCEPSessionNegotiator
extends AbstractPCEPSessionNegotiator {
    private final PCEPSessionListener listener;
    private final int maxUnknownMessages;
    private final Open myLocalPrefs;

    public DefaultPCEPSessionNegotiator(Promise<PCEPSession> promise, Channel channel, PCEPSessionListener listener, Uint8 sessionId, Open localPrefs, Uint16 maxUnknownMessages, PcepSessionTls tlsConfiguration) {
        super(promise, channel, tlsConfiguration);
        this.listener = Objects.requireNonNull(listener);
        this.maxUnknownMessages = maxUnknownMessages.toJava();
        this.myLocalPrefs = new OpenBuilder().setKeepalive(localPrefs.getKeepalive()).setDeadTimer(localPrefs.getDeadTimer()).setSessionId(Objects.requireNonNull(sessionId)).setTlvs(localPrefs.getTlvs()).build();
    }

    public DefaultPCEPSessionNegotiator(Promise<PCEPSession> promise, Channel channel, PCEPSessionListener listener, Uint8 sessionId, Open localPrefs, Uint16 maxUnknownMessages) {
        this(promise, channel, listener, sessionId, localPrefs, maxUnknownMessages, null);
    }

    @Override
    protected Open getInitialProposal() {
        return this.myLocalPrefs;
    }

    @Override
    @VisibleForTesting
    public PCEPSessionImpl createSession(Channel channel, Open localPrefs, Open remotePrefs) {
        return new PCEPSessionImpl(this.listener, this.maxUnknownMessages, channel, localPrefs, remotePrefs);
    }

    @Override
    protected boolean isProposalAcceptable(Open open) {
        return true;
    }

    @Override
    protected Open getCounterProposal(Open open) {
        return null;
    }

    @Override
    protected Open getRevisedProposal(Open suggestion) {
        return this.myLocalPrefs;
    }
}

