/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl.tls;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.session.tls.PathType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslKeyStore {
    private static final Logger LOG = LoggerFactory.getLogger(SslKeyStore.class);

    private SslKeyStore() {
    }

    public static InputStream asInputStream(String filename, PathType pathType) {
        InputStream in;
        switch (pathType) {
            case CLASSPATH: {
                in = SslKeyStore.class.getResourceAsStream(filename);
                Preconditions.checkArgument((in != null ? 1 : 0) != 0, (String)"KeyStore file not found: %s", (Object)filename);
                break;
            }
            case PATH: {
                LOG.debug("Current dir using System: {}", (Object)System.getProperty("user.dir"));
                File keystorefile = new File(filename);
                try {
                    in = new FileInputStream(keystorefile);
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException("KeyStore file not found: " + filename, e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown path type: " + pathType);
            }
        }
        return in;
    }
}

