/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.primitives.UnsignedBytes;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.SessionNegotiator;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.AbstractSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.PCEPPeerRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPCEPSessionNegotiatorFactory
implements PCEPSessionNegotiatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPCEPSessionNegotiatorFactory.class);
    private final PCEPPeerRegistry sessionRegistry = new PCEPPeerRegistry();

    protected abstract AbstractPCEPSessionNegotiator createNegotiator(Promise<PCEPSession> var1, Channel var2, Uint8 var3);

    public final SessionNegotiator getSessionNegotiator(Channel channel, Promise<PCEPSession> promise) {
        LOG.debug("Instantiating bootstrap negotiator for channel {}", (Object)channel);
        return new BootstrapSessionNegotiator(channel, promise);
    }

    private final class BootstrapSessionNegotiator
    extends AbstractSessionNegotiator {
        private static final Comparator<byte[]> COMPARATOR = UnsignedBytes.lexicographicalComparator();

        BootstrapSessionNegotiator(Channel channel, Promise<PCEPSession> promise) {
            super(promise, channel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void startNegotiation() throws ExecutionException {
            BootstrapSessionNegotiator lock = this;
            LOG.debug("Bootstrap negotiation for channel {} started", (Object)this.channel);
            final byte[] clientAddress = ((InetSocketAddress)this.channel.remoteAddress()).getAddress().getAddress();
            BootstrapSessionNegotiator bootstrapSessionNegotiator = lock;
            synchronized (bootstrapSessionNegotiator) {
                if (AbstractPCEPSessionNegotiatorFactory.this.sessionRegistry.getSessionReference(clientAddress).isPresent()) {
                    byte[] serverAddress = ((InetSocketAddress)this.channel.localAddress()).getAddress().getAddress();
                    if (COMPARATOR.compare(serverAddress, clientAddress) > 0) {
                        AbstractPCEPSessionNegotiatorFactory.this.sessionRegistry.removeSessionReference(clientAddress).ifPresent(sessionRef -> {
                            try {
                                sessionRef.close();
                            }
                            catch (Exception e) {
                                LOG.error("Unexpected failure to close old session", (Throwable)e);
                            }
                        });
                    } else {
                        this.negotiationFailed(new IllegalStateException("A conflicting session for address " + String.valueOf(((InetSocketAddress)this.channel.remoteAddress()).getAddress()) + " found."));
                        return;
                    }
                }
                final Uint8 sessionId = AbstractPCEPSessionNegotiatorFactory.this.sessionRegistry.nextSession(clientAddress);
                AbstractPCEPSessionNegotiator negotiator = AbstractPCEPSessionNegotiatorFactory.this.createNegotiator((Promise<PCEPSession>)this.promise, this.channel, sessionId);
                AbstractPCEPSessionNegotiatorFactory.this.sessionRegistry.putSessionReference(clientAddress, new PCEPPeerRegistry.SessionReference(){

                    @Override
                    public void close() throws ExecutionException {
                        try {
                            AbstractPCEPSessionNegotiatorFactory.this.sessionRegistry.releaseSession(clientAddress, sessionId);
                        }
                        finally {
                            BootstrapSessionNegotiator.this.channel.close();
                        }
                    }

                    @Override
                    public Uint8 getSessionId() {
                        return sessionId;
                    }
                });
                this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> this.lambda$startNegotiation$1((Object)((Object)lock), clientAddress, arg_0)));
                LOG.info("Replacing bootstrap negotiator for channel {}", (Object)this.channel);
                this.channel.pipeline().replace((ChannelHandler)this, "negotiator", (ChannelHandler)negotiator);
                negotiator.startNegotiation();
            }
        }

        @Override
        protected void handleMessage(Message msg) {
            throw new IllegalStateException("Bootstrap negotiator should have been replaced");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private /* synthetic */ void lambda$startNegotiation$1(Object lock, byte[] clientAddress, ChannelFuture future) throws Exception {
            Object object = lock;
            synchronized (object) {
                AbstractPCEPSessionNegotiatorFactory.this.sessionRegistry.removeSessionReference(clientAddress);
            }
        }
    }
}

