/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.protocol.concepts.KeyMapping;
import org.opendaylight.protocol.pcep.MessageRegistry;
import org.opendaylight.protocol.pcep.PCEPDispatcher;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.impl.PCEPHandlerFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={PCEPDispatcher.class})
@Designate(ocd=Configuration.class)
public class PCEPDispatcherImpl
implements PCEPDispatcher,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPDispatcherImpl.class);
    private static final int DEFAULT_SHUTDOWN_SECONDS = 10;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final EventExecutor executor = (EventExecutor)Objects.requireNonNull(GlobalEventExecutor.INSTANCE);
    private final int shutdownTimeSeconds;

    public PCEPDispatcherImpl() {
        this(0, 0, 10);
    }

    @Activate
    public PCEPDispatcherImpl(Configuration config) {
        this(config.bossThreads(), config.workerThreads(), config.shutdownTimeSeconds());
    }

    @Inject
    public PCEPDispatcherImpl(int bossThreads, int workerThreads, int shutdownTimeSeconds) {
        ThreadFactory bossTf = new ThreadFactoryBuilder().setNameFormat("pcep-boss-%d").build();
        ThreadFactory workerTf = new ThreadFactoryBuilder().setNameFormat("pcep-worker-%d").build();
        if (Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup(bossThreads, bossTf);
            this.workerGroup = new EpollEventLoopGroup(workerThreads, workerTf);
        } else {
            this.bossGroup = new NioEventLoopGroup(bossThreads, bossTf);
            this.workerGroup = new NioEventLoopGroup(workerThreads, workerTf);
        }
        this.shutdownTimeSeconds = shutdownTimeSeconds;
    }

    public final synchronized ChannelFuture createServer(InetSocketAddress listenAddress, KeyMapping tcpKeys, MessageRegistry registry, PCEPSessionNegotiatorFactory negotiatorFactory) {
        PCEPHandlerFactory hf = new PCEPHandlerFactory(registry);
        ChannelPipelineInitializer initializer = (ch, promise) -> {
            ch.pipeline().addLast(hf.getDecoders());
            ch.pipeline().addLast("negotiator", (ChannelHandler)negotiatorFactory.getSessionNegotiator((Channel)ch, promise));
            ch.pipeline().addLast(hf.getEncoders());
        };
        ServerBootstrap b = this.createServerBootstrap(initializer, tcpKeys);
        ChannelFuture f = b.bind((SocketAddress)listenAddress);
        LOG.debug("Initiated server {} at {}.", (Object)f, (Object)listenAddress);
        return f;
    }

    @VisibleForTesting
    ServerBootstrap createServerBootstrap(final ChannelPipelineInitializer initializer, KeyMapping tcpKeys) {
        ServerBootstrap b = new ServerBootstrap();
        b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                initializer.initializeChannel(ch, (Promise<PCEPSession>)new DefaultPromise(PCEPDispatcherImpl.this.executor));
            }
        });
        b.option(ChannelOption.SO_BACKLOG, (Object)128);
        b.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        if (Epoll.isAvailable()) {
            b.channel(EpollServerSocketChannel.class);
            b.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.LEVEL_TRIGGERED);
        } else {
            b.channel(NioServerSocketChannel.class);
        }
        if (!tcpKeys.isEmpty()) {
            if (Epoll.isAvailable()) {
                b.option(EpollChannelOption.TCP_MD5SIG, (Object)tcpKeys.asMap());
            } else {
                throw new UnsupportedOperationException("Setting TCP-MD5 signatures is not supported", Epoll.unavailabilityCause().getCause());
            }
        }
        b.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(1));
        if (b.config().group() == null) {
            b.group(this.bossGroup, this.workerGroup);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    @Deactivate
    public final void close() {
        long now = System.nanoTime();
        long deadline = now + TimeUnit.SECONDS.toNanos(this.shutdownTimeSeconds);
        try {
            this.bossGroup.shutdownGracefully(0L, deadline - now, TimeUnit.NANOSECONDS);
        }
        finally {
            this.workerGroup.shutdownGracefully(0L, deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
        }
    }

    @ObjectClassDefinition(description="Configuration of the OSGiBgpDeployer")
    public static @interface Configuration {
        @AttributeDefinition(description="Maximum number of threads servicing the socket, 0 means as many as there are process cores", min="0")
        public int bossThreads() default 0;

        @AttributeDefinition(description="Maximum number of threads servicing sessions, 0 means as many as there are process cores", min="0")
        public int workerThreads() default 0;

        @AttributeDefinition(description="Maximum time (seconds) to wait for shutdown", min="0")
        public int shutdownTimeSeconds() default 10;
    }

    protected static interface ChannelPipelineInitializer {
        public void initializeChannel(SocketChannel var1, Promise<PCEPSession> var2);
    }
}

