/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.yangtools.yang.common.Uint8;

final class PeerRecord {
    private final @GuardedBy(value={"this"}) Cache<Short, Short> pastIds;
    private @GuardedBy(value={"this"}) Uint8 lastId;

    PeerRecord(long idLifetimeSeconds, Uint8 lastId) {
        this.pastIds = CacheBuilder.newBuilder().expireAfterWrite(idLifetimeSeconds, TimeUnit.SECONDS).maximumSize(255L).build();
        this.lastId = lastId;
    }

    synchronized Uint8 allocId() {
        Uint8 ret;
        short id;
        short s = id = this.lastId == null ? (short)0 : this.lastId.toJava();
        while (this.pastIds.getIfPresent((Object)id) != null) {
            id = (short)((id + 1) % 255);
        }
        this.pastIds.put((Object)id, (Object)id);
        this.lastId = ret = Uint8.valueOf((short)id);
        return ret;
    }
}

