/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.protocol.pcep.impl.PeerRecord;
import org.opendaylight.yangtools.yang.common.Uint8;

final class PCEPPeerRegistry {
    private static final long ID_CACHE_SECONDS = 10800L;
    private static final long PEER_CACHE_SECONDS = 86400L;
    private static final long PEER_CACHE_SIZE = 1024L;
    private final @GuardedBy(value={"this"}) Cache<ByteArrayWrapper, PeerRecord> formerClients = CacheBuilder.newBuilder().expireAfterAccess(86400L, TimeUnit.SECONDS).maximumSize(1024L).build();
    private final @GuardedBy(value={"this"}) Map<ByteArrayWrapper, SessionReference> sessions = new HashMap<ByteArrayWrapper, SessionReference>();

    PCEPPeerRegistry() {
    }

    protected synchronized Optional<SessionReference> getSessionReference(byte[] clientAddress) {
        SessionReference sessionReference = this.sessions.get(new ByteArrayWrapper(clientAddress));
        if (sessionReference != null) {
            return Optional.of(sessionReference);
        }
        return Optional.empty();
    }

    protected synchronized Optional<SessionReference> removeSessionReference(byte[] clientAddress) {
        return Optional.ofNullable(this.sessions.remove(new ByteArrayWrapper(clientAddress)));
    }

    protected synchronized void putSessionReference(byte[] clientAddress, SessionReference sessionReference) {
        this.sessions.put(new ByteArrayWrapper(clientAddress), sessionReference);
    }

    protected synchronized Uint8 nextSession(byte[] clientAddress) throws ExecutionException {
        PeerRecord peer = (PeerRecord)this.formerClients.get((Object)new ByteArrayWrapper(clientAddress), () -> new PeerRecord(10800L, null));
        return peer.allocId();
    }

    protected synchronized void releaseSession(byte[] clientAddress, Uint8 sessionId) throws ExecutionException {
        this.formerClients.get((Object)new ByteArrayWrapper(clientAddress), () -> new PeerRecord(10800L, sessionId));
    }

    private static final class ByteArrayWrapper {
        private final byte[] byteArray;

        ByteArrayWrapper(byte[] byteArray) {
            this.byteArray = byteArray == null ? null : (byte[])byteArray.clone();
        }

        public int hashCode() {
            return Arrays.hashCode(this.byteArray);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof ByteArrayWrapper)) return false;
            ByteArrayWrapper other = (ByteArrayWrapper)obj;
            if (!Arrays.equals(this.byteArray, other.byteArray)) return false;
            return true;
        }
    }

    protected static interface SessionReference
    extends AutoCloseable {
        public Uint8 getSessionId();
    }
}

