/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.channel.Channel;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.protocol.pcep.PCEPCapability;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionListenerFactory;
import org.opendaylight.protocol.pcep.PCEPTimerProposal;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiator;
import org.opendaylight.protocol.pcep.impl.AbstractPCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.impl.DefaultPCEPSessionNegotiator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepSessionTimers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepSessionTls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.TlvsBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

public class DefaultPCEPSessionNegotiatorFactory
extends AbstractPCEPSessionNegotiatorFactory {
    private final @NonNull PCEPSessionListenerFactory listenerFactory;
    private final @NonNull PCEPTimerProposal timers;
    private final @NonNull List<PCEPCapability> capabilities;
    private final @NonNull Uint16 maxUnknownMessages;
    private final PcepSessionTls tlsConfiguration;

    public DefaultPCEPSessionNegotiatorFactory(PCEPSessionListenerFactory listenerFactory, PcepSessionTimers timers, List<PCEPCapability> capabilities, Uint16 maxUnknownMessages) {
        this(listenerFactory, timers, capabilities, maxUnknownMessages, null);
    }

    public DefaultPCEPSessionNegotiatorFactory(PCEPSessionListenerFactory listenerFactory, PcepSessionTimers timers, List<PCEPCapability> capabilities, Uint16 maxUnknownMessages, PcepSessionTls tlsConfiguration) {
        this(listenerFactory, new PCEPTimerProposal(timers), capabilities, maxUnknownMessages, tlsConfiguration);
    }

    public DefaultPCEPSessionNegotiatorFactory(PCEPSessionListenerFactory listenerFactory, PCEPTimerProposal timers, List<PCEPCapability> capabilities, Uint16 maxUnknownMessages, PcepSessionTls tlsConfiguration) {
        this.listenerFactory = Objects.requireNonNull(listenerFactory);
        this.timers = Objects.requireNonNull(timers);
        this.capabilities = Objects.requireNonNull(capabilities);
        this.maxUnknownMessages = Objects.requireNonNull(maxUnknownMessages);
        this.tlsConfiguration = tlsConfiguration;
    }

    @Override
    protected final AbstractPCEPSessionNegotiator createNegotiator(Promise<PCEPSession> promise, Channel channel, Uint8 sessionId) {
        InetSocketAddress address = (InetSocketAddress)channel.remoteAddress();
        TlvsBuilder builder = new TlvsBuilder();
        for (PCEPCapability capability : this.capabilities) {
            capability.setCapabilityProposal(address, builder);
        }
        this.appendPeerSpecificTls(address, builder);
        return new DefaultPCEPSessionNegotiator(promise, channel, this.listenerFactory.getSessionListener(), sessionId, new OpenBuilder().setSessionId(sessionId).setKeepalive(this.timers.keepAlive()).setDeadTimer(this.timers.deadTimer()).setTlvs(builder.build()).build(), this.maxUnknownMessages, this.tlsConfiguration);
    }

    protected void appendPeerSpecificTls(@NonNull InetSocketAddress address, @NonNull TlvsBuilder builder) {
    }
}

