/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl.tls;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.session.tls.PathType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslKeyStore {
    private static final Logger LOG = LoggerFactory.getLogger(SslKeyStore.class);

    private SslKeyStore() {
    }

    public static InputStream asInputStream(String filename, PathType pathType) {
        InputStream inputStream;
        switch (pathType) {
            default: {
                throw new MatchException(null, null);
            }
            case CLASSPATH: {
                InputStream in = SslKeyStore.class.getResourceAsStream(filename);
                if (in != null) {
                    InputStream inputStream2;
                    inputStream = inputStream2 = in;
                    break;
                }
                throw new IllegalArgumentException("KeyStore file not found: " + filename);
            }
            case PATH: {
                LOG.debug("Current dir using System: {}", (Object)System.getProperty("user.dir"));
                Path keystorefile = Path.of(filename, new String[0]);
                try {
                    InputStream inputStream3;
                    inputStream = inputStream3 = Files.newInputStream(keystorefile, new OpenOption[0]);
                    break;
                }
                catch (IOException e) {
                    throw new IllegalStateException("KeyStore file not found: " + filename, e);
                }
            }
        }
        return inputStream;
    }
}

