package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl
 */
public class PcepSessionProposalFactoryImplBuilder {

    private java.lang.Short _deadTimerValue;
    private static List<Range<BigInteger>> _deadTimerValue_range;
    private java.lang.Short _keepAliveTimerValue;
    private static List<Range<BigInteger>> _keepAliveTimerValue_range;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>> augmentation = new HashMap<>();

    public PcepSessionProposalFactoryImplBuilder() {
    } 
    

    public PcepSessionProposalFactoryImplBuilder(PcepSessionProposalFactoryImpl base) {
        this._deadTimerValue = base.getDeadTimerValue();
        this._keepAliveTimerValue = base.getKeepAliveTimerValue();
        if (base instanceof PcepSessionProposalFactoryImplImpl) {
            PcepSessionProposalFactoryImplImpl _impl = (PcepSessionProposalFactoryImplImpl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }


    public java.lang.Short getDeadTimerValue() {
        return _deadTimerValue;
    }
    
    public java.lang.Short getKeepAliveTimerValue() {
        return _keepAliveTimerValue;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public PcepSessionProposalFactoryImplBuilder setDeadTimerValue(java.lang.Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _deadTimerValue_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _deadTimerValue_range));
            }
        }
        this._deadTimerValue = value;
        return this;
    }
    public static List<Range<BigInteger>> _deadTimerValue_range() {
        if (_deadTimerValue_range == null) {
            synchronized (PcepSessionProposalFactoryImplBuilder.class) {
                if (_deadTimerValue_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
                    _deadTimerValue_range = builder.build();
                }
            }
        }
        return _deadTimerValue_range;
    }
    
    public PcepSessionProposalFactoryImplBuilder setKeepAliveTimerValue(java.lang.Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _keepAliveTimerValue_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _keepAliveTimerValue_range));
            }
        }
        this._keepAliveTimerValue = value;
        return this;
    }
    public static List<Range<BigInteger>> _keepAliveTimerValue_range() {
        if (_keepAliveTimerValue_range == null) {
            synchronized (PcepSessionProposalFactoryImplBuilder.class) {
                if (_keepAliveTimerValue_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
                    _keepAliveTimerValue_range = builder.build();
                }
            }
        }
        return _keepAliveTimerValue_range;
    }
    
    public PcepSessionProposalFactoryImplBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcepSessionProposalFactoryImpl build() {
        return new PcepSessionProposalFactoryImplImpl(this);
    }

    private static final class PcepSessionProposalFactoryImplImpl implements PcepSessionProposalFactoryImpl {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl.class;
        }

        private final java.lang.Short _deadTimerValue;
        private final java.lang.Short _keepAliveTimerValue;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>> augmentation = new HashMap<>();

        private PcepSessionProposalFactoryImplImpl(PcepSessionProposalFactoryImplBuilder base) {
            this._deadTimerValue = base.getDeadTimerValue();
            this._keepAliveTimerValue = base.getKeepAliveTimerValue();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public java.lang.Short getDeadTimerValue() {
            return _deadTimerValue;
        }
        
        @Override
        public java.lang.Short getKeepAliveTimerValue() {
            return _keepAliveTimerValue;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_deadTimerValue == null) ? 0 : _deadTimerValue.hashCode());
            result = prime * result + ((_keepAliveTimerValue == null) ? 0 : _keepAliveTimerValue.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl)obj;
            if (_deadTimerValue == null) {
                if (other.getDeadTimerValue() != null) {
                    return false;
                }
            } else if(!_deadTimerValue.equals(other.getDeadTimerValue())) {
                return false;
            }
            if (_keepAliveTimerValue == null) {
                if (other.getKeepAliveTimerValue() != null) {
                    return false;
                }
            } else if(!_keepAliveTimerValue.equals(other.getKeepAliveTimerValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PcepSessionProposalFactoryImplImpl otherImpl = (PcepSessionProposalFactoryImplImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepSessionProposalFactoryImpl>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("PcepSessionProposalFactoryImpl [");
            boolean first = true;
        
            if (_deadTimerValue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_deadTimerValue=");
                builder.append(_deadTimerValue);
             }
            if (_keepAliveTimerValue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keepAliveTimerValue=");
                builder.append(_keepAliveTimerValue);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
