package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627;


/**
 * The enumeration built-in type represents values from a set of assigned names.
 *
 */
public enum StoreType {
    JKS(0),
    
    PKCS12(1)
    ;


    int value;
    private static final java.util.Map<java.lang.Integer, StoreType> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, StoreType> b = com.google.common.collect.ImmutableMap.builder();
        for (StoreType enumItem : StoreType.values())
        {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private StoreType(int value) {
        this.value = value;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg
     * @return corresponding StoreType item
     */
    public static StoreType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
