package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.PcepExtensions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.BossGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Md5ServerChannelFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.WorkerGroup;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Md5ChannelFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.Configuration;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.PcepSessionProposalFactory;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;odl-pcep-impl-cfg&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/odl-pcep-impl-cfg.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * case pcep-dispatcher-impl {
 *     leaf max-unknown-messages {
 *         type uint16;
 *     }
 *     container pcep-extensions {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:controller:pcep:impl?revision=2013-06-27)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container pcep-session-proposal-factory {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:controller:pcep:impl?revision=2013-06-27)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container boss-group {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:controller:pcep:impl?revision=2013-06-27)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container worker-group {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:controller:pcep:impl?revision=2013-06-27)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container md5-channel-factory {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:controller:pcep:impl?revision=2013-06-27)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container md5-server-channel-factory {
 *         leaf type {
 *             type leafref;
 *         }
 *         leaf name {
 *             type leafref;
 *         }
 *         uses service-ref {
 *             refine (urn:opendaylight:params:xml:ns:yang:controller:pcep:impl?revision=2013-06-27)type {
 *                 leaf type {
 *                     type leafref;
 *                 }
 *             }
 *         }
 *     }
 *     container tls {
 *         leaf keystore {
 *             type string;
 *         }
 *         leaf keystore-type {
 *             type store-type;
 *         }
 *         leaf keystore-path-type {
 *             type path-type;
 *         }
 *         leaf keystore-password {
 *             type string;
 *         }
 *         leaf certificate-password {
 *             type string;
 *         }
 *         leaf truststore {
 *             type string;
 *         }
 *         leaf truststore-type {
 *             type store-type;
 *         }
 *         leaf truststore-path-type {
 *             type path-type;
 *         }
 *         leaf truststore-password {
 *             type string;
 *         }
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;odl-pcep-impl-cfg/modules/module/configuration/(urn:opendaylight:params:xml:ns:yang:controller:pcep:impl?revision=2013-06-27)pcep-dispatcher-impl&lt;/i&gt;
 *
 */
public interface PcepDispatcherImpl
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>,
    Configuration
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:impl","2013-06-27","pcep-dispatcher-impl"));

    java.lang.Integer getMaxUnknownMessages();
    
    PcepExtensions getPcepExtensions();
    
    PcepSessionProposalFactory getPcepSessionProposalFactory();
    
    BossGroup getBossGroup();
    
    WorkerGroup getWorkerGroup();
    
    Md5ChannelFactory getMd5ChannelFactory();
    
    Md5ServerChannelFactory getMd5ServerChannelFactory();
    
    Tls getTls();

}

