package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration;
import com.google.common.collect.Range;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.BossGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Md5ServerChannelFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.WorkerGroup;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Md5ChannelFactory;
import java.math.BigInteger;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.PcepSessionProposalFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.PcepExtensions;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl
 *
 */
public class PcepDispatcherImplBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl> {

    private BossGroup _bossGroup;
    private java.lang.Integer _maxUnknownMessages;
    private Md5ChannelFactory _md5ChannelFactory;
    private Md5ServerChannelFactory _md5ServerChannelFactory;
    private PcepExtensions _pcepExtensions;
    private PcepSessionProposalFactory _pcepSessionProposalFactory;
    private Tls _tls;
    private WorkerGroup _workerGroup;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>> augmentation = Collections.emptyMap();

    public PcepDispatcherImplBuilder() {
    }

    public PcepDispatcherImplBuilder(PcepDispatcherImpl base) {
        this._bossGroup = base.getBossGroup();
        this._maxUnknownMessages = base.getMaxUnknownMessages();
        this._md5ChannelFactory = base.getMd5ChannelFactory();
        this._md5ServerChannelFactory = base.getMd5ServerChannelFactory();
        this._pcepExtensions = base.getPcepExtensions();
        this._pcepSessionProposalFactory = base.getPcepSessionProposalFactory();
        this._tls = base.getTls();
        this._workerGroup = base.getWorkerGroup();
        if (base instanceof PcepDispatcherImplImpl) {
            PcepDispatcherImplImpl impl = (PcepDispatcherImplImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public BossGroup getBossGroup() {
        return _bossGroup;
    }
    
    public java.lang.Integer getMaxUnknownMessages() {
        return _maxUnknownMessages;
    }
    
    public Md5ChannelFactory getMd5ChannelFactory() {
        return _md5ChannelFactory;
    }
    
    public Md5ServerChannelFactory getMd5ServerChannelFactory() {
        return _md5ServerChannelFactory;
    }
    
    public PcepExtensions getPcepExtensions() {
        return _pcepExtensions;
    }
    
    public PcepSessionProposalFactory getPcepSessionProposalFactory() {
        return _pcepSessionProposalFactory;
    }
    
    public Tls getTls() {
        return _tls;
    }
    
    public WorkerGroup getWorkerGroup() {
        return _workerGroup;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public PcepDispatcherImplBuilder setBossGroup(BossGroup value) {
        this._bossGroup = value;
        return this;
    }
    
    private static void checkMaxUnknownMessagesRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public PcepDispatcherImplBuilder setMaxUnknownMessages(java.lang.Integer value) {
        if (value != null) {
            checkMaxUnknownMessagesRange(value);
        }
        this._maxUnknownMessages = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _maxUnknownMessages_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    public PcepDispatcherImplBuilder setMd5ChannelFactory(Md5ChannelFactory value) {
        this._md5ChannelFactory = value;
        return this;
    }
    
    public PcepDispatcherImplBuilder setMd5ServerChannelFactory(Md5ServerChannelFactory value) {
        this._md5ServerChannelFactory = value;
        return this;
    }
    
    public PcepDispatcherImplBuilder setPcepExtensions(PcepExtensions value) {
        this._pcepExtensions = value;
        return this;
    }
    
    public PcepDispatcherImplBuilder setPcepSessionProposalFactory(PcepSessionProposalFactory value) {
        this._pcepSessionProposalFactory = value;
        return this;
    }
    
    public PcepDispatcherImplBuilder setTls(Tls value) {
        this._tls = value;
        return this;
    }
    
    public PcepDispatcherImplBuilder setWorkerGroup(WorkerGroup value) {
        this._workerGroup = value;
        return this;
    }
    
    public PcepDispatcherImplBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public PcepDispatcherImplBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PcepDispatcherImpl build() {
        return new PcepDispatcherImplImpl(this);
    }

    private static final class PcepDispatcherImplImpl implements PcepDispatcherImpl {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl.class;
        }

        private final BossGroup _bossGroup;
        private final java.lang.Integer _maxUnknownMessages;
        private final Md5ChannelFactory _md5ChannelFactory;
        private final Md5ServerChannelFactory _md5ServerChannelFactory;
        private final PcepExtensions _pcepExtensions;
        private final PcepSessionProposalFactory _pcepSessionProposalFactory;
        private final Tls _tls;
        private final WorkerGroup _workerGroup;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>> augmentation = Collections.emptyMap();

        private PcepDispatcherImplImpl(PcepDispatcherImplBuilder base) {
            this._bossGroup = base.getBossGroup();
            this._maxUnknownMessages = base.getMaxUnknownMessages();
            this._md5ChannelFactory = base.getMd5ChannelFactory();
            this._md5ServerChannelFactory = base.getMd5ServerChannelFactory();
            this._pcepExtensions = base.getPcepExtensions();
            this._pcepSessionProposalFactory = base.getPcepSessionProposalFactory();
            this._tls = base.getTls();
            this._workerGroup = base.getWorkerGroup();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public BossGroup getBossGroup() {
            return _bossGroup;
        }
        
        @Override
        public java.lang.Integer getMaxUnknownMessages() {
            return _maxUnknownMessages;
        }
        
        @Override
        public Md5ChannelFactory getMd5ChannelFactory() {
            return _md5ChannelFactory;
        }
        
        @Override
        public Md5ServerChannelFactory getMd5ServerChannelFactory() {
            return _md5ServerChannelFactory;
        }
        
        @Override
        public PcepExtensions getPcepExtensions() {
            return _pcepExtensions;
        }
        
        @Override
        public PcepSessionProposalFactory getPcepSessionProposalFactory() {
            return _pcepSessionProposalFactory;
        }
        
        @Override
        public Tls getTls() {
            return _tls;
        }
        
        @Override
        public WorkerGroup getWorkerGroup() {
            return _workerGroup;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_bossGroup == null) ? 0 : _bossGroup.hashCode());
            result = prime * result + ((_maxUnknownMessages == null) ? 0 : _maxUnknownMessages.hashCode());
            result = prime * result + ((_md5ChannelFactory == null) ? 0 : _md5ChannelFactory.hashCode());
            result = prime * result + ((_md5ServerChannelFactory == null) ? 0 : _md5ServerChannelFactory.hashCode());
            result = prime * result + ((_pcepExtensions == null) ? 0 : _pcepExtensions.hashCode());
            result = prime * result + ((_pcepSessionProposalFactory == null) ? 0 : _pcepSessionProposalFactory.hashCode());
            result = prime * result + ((_tls == null) ? 0 : _tls.hashCode());
            result = prime * result + ((_workerGroup == null) ? 0 : _workerGroup.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl)obj;
            if (_bossGroup == null) {
                if (other.getBossGroup() != null) {
                    return false;
                }
            } else if(!_bossGroup.equals(other.getBossGroup())) {
                return false;
            }
            if (_maxUnknownMessages == null) {
                if (other.getMaxUnknownMessages() != null) {
                    return false;
                }
            } else if(!_maxUnknownMessages.equals(other.getMaxUnknownMessages())) {
                return false;
            }
            if (_md5ChannelFactory == null) {
                if (other.getMd5ChannelFactory() != null) {
                    return false;
                }
            } else if(!_md5ChannelFactory.equals(other.getMd5ChannelFactory())) {
                return false;
            }
            if (_md5ServerChannelFactory == null) {
                if (other.getMd5ServerChannelFactory() != null) {
                    return false;
                }
            } else if(!_md5ServerChannelFactory.equals(other.getMd5ServerChannelFactory())) {
                return false;
            }
            if (_pcepExtensions == null) {
                if (other.getPcepExtensions() != null) {
                    return false;
                }
            } else if(!_pcepExtensions.equals(other.getPcepExtensions())) {
                return false;
            }
            if (_pcepSessionProposalFactory == null) {
                if (other.getPcepSessionProposalFactory() != null) {
                    return false;
                }
            } else if(!_pcepSessionProposalFactory.equals(other.getPcepSessionProposalFactory())) {
                return false;
            }
            if (_tls == null) {
                if (other.getTls() != null) {
                    return false;
                }
            } else if(!_tls.equals(other.getTls())) {
                return false;
            }
            if (_workerGroup == null) {
                if (other.getWorkerGroup() != null) {
                    return false;
                }
            } else if(!_workerGroup.equals(other.getWorkerGroup())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PcepDispatcherImplImpl otherImpl = (PcepDispatcherImplImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.PcepDispatcherImpl>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("PcepDispatcherImpl [");
            boolean first = true;
        
            if (_bossGroup != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bossGroup=");
                builder.append(_bossGroup);
             }
            if (_maxUnknownMessages != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxUnknownMessages=");
                builder.append(_maxUnknownMessages);
             }
            if (_md5ChannelFactory != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_md5ChannelFactory=");
                builder.append(_md5ChannelFactory);
             }
            if (_md5ServerChannelFactory != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_md5ServerChannelFactory=");
                builder.append(_md5ServerChannelFactory);
             }
            if (_pcepExtensions != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pcepExtensions=");
                builder.append(_pcepExtensions);
             }
            if (_pcepSessionProposalFactory != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pcepSessionProposalFactory=");
                builder.append(_pcepSessionProposalFactory);
             }
            if (_tls != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tls=");
                builder.append(_tls);
             }
            if (_workerGroup != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_workerGroup=");
                builder.append(_workerGroup);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
