package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.StoreType;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.Module;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.PathType;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;odl-pcep-impl-cfg&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/odl-pcep-impl-cfg.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container tls {
 *     leaf keystore {
 *         type string;
 *     }
 *     leaf keystore-type {
 *         type store-type;
 *     }
 *     leaf keystore-path-type {
 *         type path-type;
 *     }
 *     leaf keystore-password {
 *         type string;
 *     }
 *     leaf certificate-password {
 *         type string;
 *     }
 *     leaf truststore {
 *         type string;
 *     }
 *     leaf truststore-type {
 *         type store-type;
 *     }
 *     leaf truststore-path-type {
 *         type path-type;
 *     }
 *     leaf truststore-password {
 *         type string;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;odl-pcep-impl-cfg/modules/module/configuration/(urn:opendaylight:params:xml:ns:yang:controller:pcep:impl?revision=2013-06-27)pcep-dispatcher-impl/tls&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.TlsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.TlsBuilder
 *
 */
public interface Tls
    extends
    ChildOf<Module>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:impl","2013-06-27","tls"));

    /**
     * keystore location
     *
     */
    java.lang.String getKeystore();
    
    /**
     * keystore type (JKS or PKCS12)
     *
     */
    StoreType getKeystoreType();
    
    /**
     * keystore path type (CLASSPATH or PATH)
     *
     */
    PathType getKeystorePathType();
    
    /**
     * password protecting keystore
     *
     */
    java.lang.String getKeystorePassword();
    
    /**
     * password protecting certificate
     *
     */
    java.lang.String getCertificatePassword();
    
    /**
     * truststore location
     *
     */
    java.lang.String getTruststore();
    
    /**
     * truststore type (JKS or PKCS12)
     *
     */
    StoreType getTruststoreType();
    
    /**
     * truststore path type (CLASSPATH or PATH)
     *
     */
    PathType getTruststorePathType();
    
    /**
     * password protecting truststore
     *
     */
    java.lang.String getTruststorePassword();

}

