package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.StoreType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.PathType;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls
 *
 */
public class TlsBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls> {

    private java.lang.String _certificatePassword;
    private java.lang.String _keystore;
    private java.lang.String _keystorePassword;
    private PathType _keystorePathType;
    private StoreType _keystoreType;
    private java.lang.String _truststore;
    private java.lang.String _truststorePassword;
    private PathType _truststorePathType;
    private StoreType _truststoreType;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>> augmentation = Collections.emptyMap();

    public TlsBuilder() {
    }

    public TlsBuilder(Tls base) {
        this._certificatePassword = base.getCertificatePassword();
        this._keystore = base.getKeystore();
        this._keystorePassword = base.getKeystorePassword();
        this._keystorePathType = base.getKeystorePathType();
        this._keystoreType = base.getKeystoreType();
        this._truststore = base.getTruststore();
        this._truststorePassword = base.getTruststorePassword();
        this._truststorePathType = base.getTruststorePathType();
        this._truststoreType = base.getTruststoreType();
        if (base instanceof TlsImpl) {
            TlsImpl impl = (TlsImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.String getCertificatePassword() {
        return _certificatePassword;
    }
    
    public java.lang.String getKeystore() {
        return _keystore;
    }
    
    public java.lang.String getKeystorePassword() {
        return _keystorePassword;
    }
    
    public PathType getKeystorePathType() {
        return _keystorePathType;
    }
    
    public StoreType getKeystoreType() {
        return _keystoreType;
    }
    
    public java.lang.String getTruststore() {
        return _truststore;
    }
    
    public java.lang.String getTruststorePassword() {
        return _truststorePassword;
    }
    
    public PathType getTruststorePathType() {
        return _truststorePathType;
    }
    
    public StoreType getTruststoreType() {
        return _truststoreType;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public TlsBuilder setCertificatePassword(java.lang.String value) {
        this._certificatePassword = value;
        return this;
    }
    
    public TlsBuilder setKeystore(java.lang.String value) {
        this._keystore = value;
        return this;
    }
    
    public TlsBuilder setKeystorePassword(java.lang.String value) {
        this._keystorePassword = value;
        return this;
    }
    
    public TlsBuilder setKeystorePathType(PathType value) {
        this._keystorePathType = value;
        return this;
    }
    
    public TlsBuilder setKeystoreType(StoreType value) {
        this._keystoreType = value;
        return this;
    }
    
    public TlsBuilder setTruststore(java.lang.String value) {
        this._truststore = value;
        return this;
    }
    
    public TlsBuilder setTruststorePassword(java.lang.String value) {
        this._truststorePassword = value;
        return this;
    }
    
    public TlsBuilder setTruststorePathType(PathType value) {
        this._truststorePathType = value;
        return this;
    }
    
    public TlsBuilder setTruststoreType(StoreType value) {
        this._truststoreType = value;
        return this;
    }
    
    public TlsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public TlsBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Tls build() {
        return new TlsImpl(this);
    }

    private static final class TlsImpl implements Tls {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls.class;
        }

        private final java.lang.String _certificatePassword;
        private final java.lang.String _keystore;
        private final java.lang.String _keystorePassword;
        private final PathType _keystorePathType;
        private final StoreType _keystoreType;
        private final java.lang.String _truststore;
        private final java.lang.String _truststorePassword;
        private final PathType _truststorePathType;
        private final StoreType _truststoreType;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>> augmentation = Collections.emptyMap();

        private TlsImpl(TlsBuilder base) {
            this._certificatePassword = base.getCertificatePassword();
            this._keystore = base.getKeystore();
            this._keystorePassword = base.getKeystorePassword();
            this._keystorePathType = base.getKeystorePathType();
            this._keystoreType = base.getKeystoreType();
            this._truststore = base.getTruststore();
            this._truststorePassword = base.getTruststorePassword();
            this._truststorePathType = base.getTruststorePathType();
            this._truststoreType = base.getTruststoreType();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.String getCertificatePassword() {
            return _certificatePassword;
        }
        
        @Override
        public java.lang.String getKeystore() {
            return _keystore;
        }
        
        @Override
        public java.lang.String getKeystorePassword() {
            return _keystorePassword;
        }
        
        @Override
        public PathType getKeystorePathType() {
            return _keystorePathType;
        }
        
        @Override
        public StoreType getKeystoreType() {
            return _keystoreType;
        }
        
        @Override
        public java.lang.String getTruststore() {
            return _truststore;
        }
        
        @Override
        public java.lang.String getTruststorePassword() {
            return _truststorePassword;
        }
        
        @Override
        public PathType getTruststorePathType() {
            return _truststorePathType;
        }
        
        @Override
        public StoreType getTruststoreType() {
            return _truststoreType;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_certificatePassword == null) ? 0 : _certificatePassword.hashCode());
            result = prime * result + ((_keystore == null) ? 0 : _keystore.hashCode());
            result = prime * result + ((_keystorePassword == null) ? 0 : _keystorePassword.hashCode());
            result = prime * result + ((_keystorePathType == null) ? 0 : _keystorePathType.hashCode());
            result = prime * result + ((_keystoreType == null) ? 0 : _keystoreType.hashCode());
            result = prime * result + ((_truststore == null) ? 0 : _truststore.hashCode());
            result = prime * result + ((_truststorePassword == null) ? 0 : _truststorePassword.hashCode());
            result = prime * result + ((_truststorePathType == null) ? 0 : _truststorePathType.hashCode());
            result = prime * result + ((_truststoreType == null) ? 0 : _truststoreType.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls)obj;
            if (_certificatePassword == null) {
                if (other.getCertificatePassword() != null) {
                    return false;
                }
            } else if(!_certificatePassword.equals(other.getCertificatePassword())) {
                return false;
            }
            if (_keystore == null) {
                if (other.getKeystore() != null) {
                    return false;
                }
            } else if(!_keystore.equals(other.getKeystore())) {
                return false;
            }
            if (_keystorePassword == null) {
                if (other.getKeystorePassword() != null) {
                    return false;
                }
            } else if(!_keystorePassword.equals(other.getKeystorePassword())) {
                return false;
            }
            if (_keystorePathType == null) {
                if (other.getKeystorePathType() != null) {
                    return false;
                }
            } else if(!_keystorePathType.equals(other.getKeystorePathType())) {
                return false;
            }
            if (_keystoreType == null) {
                if (other.getKeystoreType() != null) {
                    return false;
                }
            } else if(!_keystoreType.equals(other.getKeystoreType())) {
                return false;
            }
            if (_truststore == null) {
                if (other.getTruststore() != null) {
                    return false;
                }
            } else if(!_truststore.equals(other.getTruststore())) {
                return false;
            }
            if (_truststorePassword == null) {
                if (other.getTruststorePassword() != null) {
                    return false;
                }
            } else if(!_truststorePassword.equals(other.getTruststorePassword())) {
                return false;
            }
            if (_truststorePathType == null) {
                if (other.getTruststorePathType() != null) {
                    return false;
                }
            } else if(!_truststorePathType.equals(other.getTruststorePathType())) {
                return false;
            }
            if (_truststoreType == null) {
                if (other.getTruststoreType() != null) {
                    return false;
                }
            } else if(!_truststoreType.equals(other.getTruststoreType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TlsImpl otherImpl = (TlsImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.impl.rev130627.modules.module.configuration.pcep.dispatcher.impl.Tls>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Tls [");
            boolean first = true;
        
            if (_certificatePassword != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_certificatePassword=");
                builder.append(_certificatePassword);
             }
            if (_keystore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keystore=");
                builder.append(_keystore);
             }
            if (_keystorePassword != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keystorePassword=");
                builder.append(_keystorePassword);
             }
            if (_keystorePathType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keystorePathType=");
                builder.append(_keystorePathType);
             }
            if (_keystoreType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keystoreType=");
                builder.append(_keystoreType);
             }
            if (_truststore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_truststore=");
                builder.append(_truststore);
             }
            if (_truststorePassword != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_truststorePassword=");
                builder.append(_truststorePassword);
             }
            if (_truststorePathType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_truststorePathType=");
                builder.append(_truststorePathType);
             }
            if (_truststoreType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_truststoreType=");
                builder.append(_truststoreType);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
