package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Configuration for the PCEP implementation.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * module pcep-app-config {
 *     yang-version 1;
 *     namespace "urn:opendaylight:params:xml:ns:yang:controller:pcep:app-config";
 *     prefix "pcep-app-config";
 *
 *     revision 2016-07-07 {
 *         description "Configuration for the PCEP implementation.
 *         ";
 *     }
 *
 *     container pcep-session-config {
 *         leaf dead-timer-value {
 *             type dead-timer-value;
 *         }
 *         leaf keep-alive-timer-value {
 *             type keep-alive-timer-value;
 *         }
 *     }
 *     container pcep-dispatcher-config {
 *         leaf max-unknown-messages {
 *             type max-unknown-messages;
 *         }
 *         container tls {
 *             leaf keystore {
 *                 type string;
 *             }
 *             leaf keystore-type {
 *                 type store-type;
 *             }
 *             leaf keystore-path-type {
 *                 type path-type;
 *             }
 *             leaf keystore-password {
 *                 type string;
 *             }
 *             leaf certificate-password {
 *                 type string;
 *             }
 *             leaf truststore {
 *                 type string;
 *             }
 *             leaf truststore-type {
 *                 type store-type;
 *             }
 *             leaf truststore-path-type {
 *                 type path-type;
 *             }
 *             leaf truststore-password {
 *                 type string;
 *             }
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface PcepAppConfigData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfig</code> <code>pcepSessionConfig</code>, or <code>null</code> if not present
     */
    PcepSessionConfig getPcepSessionConfig();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig</code> <code>pcepDispatcherConfig</code>, or <code>null</code> if not present
     */
    PcepDispatcherConfig getPcepDispatcherConfig();

}

