package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * container pcep-dispatcher-config {
 *     leaf max-unknown-messages {
 *         type max-unknown-messages;
 *     }
 *     container tls {
 *         leaf keystore {
 *             type string;
 *         }
 *         leaf keystore-type {
 *             type store-type;
 *         }
 *         leaf keystore-path-type {
 *             type path-type;
 *         }
 *         leaf keystore-password {
 *             type string;
 *         }
 *         leaf certificate-password {
 *             type string;
 *         }
 *         leaf truststore {
 *             type string;
 *         }
 *         leaf truststore-type {
 *             type store-type;
 *         }
 *         leaf truststore-path-type {
 *             type path-type;
 *         }
 *         leaf truststore-password {
 *             type string;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-app-config/pcep-dispatcher-config</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfigBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfigBuilder
 *
 */
public interface PcepDispatcherConfig
    extends
    ChildOf<PcepAppConfigData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:app-config",
        "2016-07-07", "pcep-dispatcher-config").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>maxUnknownMessages</code>, or <code>null</code> if not present
     */
    java.lang.Integer getMaxUnknownMessages();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls</code> <code>tls</code>, or <code>null</code> if not present
     */
    Tls getTls();

}

