package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.StoreType;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PathType;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls
 *
 */
public class TlsBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls> {

    private java.lang.String _certificatePassword;
    private java.lang.String _keystore;
    private java.lang.String _keystorePassword;
    private PathType _keystorePathType;
    private StoreType _keystoreType;
    private java.lang.String _truststore;
    private java.lang.String _truststorePassword;
    private PathType _truststorePathType;
    private StoreType _truststoreType;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>> augmentation = Collections.emptyMap();

    public TlsBuilder() {
    }

    public TlsBuilder(Tls base) {
        this._certificatePassword = base.getCertificatePassword();
        this._keystore = base.getKeystore();
        this._keystorePassword = base.getKeystorePassword();
        this._keystorePathType = base.getKeystorePathType();
        this._keystoreType = base.getKeystoreType();
        this._truststore = base.getTruststore();
        this._truststorePassword = base.getTruststorePassword();
        this._truststorePathType = base.getTruststorePathType();
        this._truststoreType = base.getTruststoreType();
        if (base instanceof TlsImpl) {
            TlsImpl impl = (TlsImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.String getCertificatePassword() {
        return _certificatePassword;
    }
    
    public java.lang.String getKeystore() {
        return _keystore;
    }
    
    public java.lang.String getKeystorePassword() {
        return _keystorePassword;
    }
    
    public PathType getKeystorePathType() {
        return _keystorePathType;
    }
    
    public StoreType getKeystoreType() {
        return _keystoreType;
    }
    
    public java.lang.String getTruststore() {
        return _truststore;
    }
    
    public java.lang.String getTruststorePassword() {
        return _truststorePassword;
    }
    
    public PathType getTruststorePathType() {
        return _truststorePathType;
    }
    
    public StoreType getTruststoreType() {
        return _truststoreType;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public TlsBuilder setCertificatePassword(final java.lang.String value) {
        this._certificatePassword = value;
        return this;
    }
    
     
    public TlsBuilder setKeystore(final java.lang.String value) {
        this._keystore = value;
        return this;
    }
    
     
    public TlsBuilder setKeystorePassword(final java.lang.String value) {
        this._keystorePassword = value;
        return this;
    }
    
     
    public TlsBuilder setKeystorePathType(final PathType value) {
        this._keystorePathType = value;
        return this;
    }
    
     
    public TlsBuilder setKeystoreType(final StoreType value) {
        this._keystoreType = value;
        return this;
    }
    
     
    public TlsBuilder setTruststore(final java.lang.String value) {
        this._truststore = value;
        return this;
    }
    
     
    public TlsBuilder setTruststorePassword(final java.lang.String value) {
        this._truststorePassword = value;
        return this;
    }
    
     
    public TlsBuilder setTruststorePathType(final PathType value) {
        this._truststorePathType = value;
        return this;
    }
    
     
    public TlsBuilder setTruststoreType(final StoreType value) {
        this._truststoreType = value;
        return this;
    }
    
    public TlsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public TlsBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Tls build() {
        return new TlsImpl(this);
    }

    private static final class TlsImpl implements Tls {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls.class;
        }

        private final java.lang.String _certificatePassword;
        private final java.lang.String _keystore;
        private final java.lang.String _keystorePassword;
        private final PathType _keystorePathType;
        private final StoreType _keystoreType;
        private final java.lang.String _truststore;
        private final java.lang.String _truststorePassword;
        private final PathType _truststorePathType;
        private final StoreType _truststoreType;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>> augmentation = Collections.emptyMap();

        private TlsImpl(TlsBuilder base) {
            this._certificatePassword = base.getCertificatePassword();
            this._keystore = base.getKeystore();
            this._keystorePassword = base.getKeystorePassword();
            this._keystorePathType = base.getKeystorePathType();
            this._keystoreType = base.getKeystoreType();
            this._truststore = base.getTruststore();
            this._truststorePassword = base.getTruststorePassword();
            this._truststorePathType = base.getTruststorePathType();
            this._truststoreType = base.getTruststoreType();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.String getCertificatePassword() {
            return _certificatePassword;
        }
        
        @Override
        public java.lang.String getKeystore() {
            return _keystore;
        }
        
        @Override
        public java.lang.String getKeystorePassword() {
            return _keystorePassword;
        }
        
        @Override
        public PathType getKeystorePathType() {
            return _keystorePathType;
        }
        
        @Override
        public StoreType getKeystoreType() {
            return _keystoreType;
        }
        
        @Override
        public java.lang.String getTruststore() {
            return _truststore;
        }
        
        @Override
        public java.lang.String getTruststorePassword() {
            return _truststorePassword;
        }
        
        @Override
        public PathType getTruststorePathType() {
            return _truststorePathType;
        }
        
        @Override
        public StoreType getTruststoreType() {
            return _truststoreType;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_certificatePassword);
            result = prime * result + Objects.hashCode(_keystore);
            result = prime * result + Objects.hashCode(_keystorePassword);
            result = prime * result + Objects.hashCode(_keystorePathType);
            result = prime * result + Objects.hashCode(_keystoreType);
            result = prime * result + Objects.hashCode(_truststore);
            result = prime * result + Objects.hashCode(_truststorePassword);
            result = prime * result + Objects.hashCode(_truststorePathType);
            result = prime * result + Objects.hashCode(_truststoreType);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls)obj;
            if (!Objects.equals(_certificatePassword, other.getCertificatePassword())) {
                return false;
            }
            if (!Objects.equals(_keystore, other.getKeystore())) {
                return false;
            }
            if (!Objects.equals(_keystorePassword, other.getKeystorePassword())) {
                return false;
            }
            if (!Objects.equals(_keystorePathType, other.getKeystorePathType())) {
                return false;
            }
            if (!Objects.equals(_keystoreType, other.getKeystoreType())) {
                return false;
            }
            if (!Objects.equals(_truststore, other.getTruststore())) {
                return false;
            }
            if (!Objects.equals(_truststorePassword, other.getTruststorePassword())) {
                return false;
            }
            if (!Objects.equals(_truststorePathType, other.getTruststorePathType())) {
                return false;
            }
            if (!Objects.equals(_truststoreType, other.getTruststoreType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                TlsImpl otherImpl = (TlsImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "Tls [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_certificatePassword != null) {
                builder.append("_certificatePassword=");
                builder.append(_certificatePassword);
                builder.append(", ");
            }
            if (_keystore != null) {
                builder.append("_keystore=");
                builder.append(_keystore);
                builder.append(", ");
            }
            if (_keystorePassword != null) {
                builder.append("_keystorePassword=");
                builder.append(_keystorePassword);
                builder.append(", ");
            }
            if (_keystorePathType != null) {
                builder.append("_keystorePathType=");
                builder.append(_keystorePathType);
                builder.append(", ");
            }
            if (_keystoreType != null) {
                builder.append("_keystoreType=");
                builder.append(_keystoreType);
                builder.append(", ");
            }
            if (_truststore != null) {
                builder.append("_truststore=");
                builder.append(_truststore);
                builder.append(", ");
            }
            if (_truststorePassword != null) {
                builder.append("_truststorePassword=");
                builder.append(_truststorePassword);
                builder.append(", ");
            }
            if (_truststorePathType != null) {
                builder.append("_truststorePathType=");
                builder.append(_truststorePathType);
                builder.append(", ");
            }
            if (_truststoreType != null) {
                builder.append("_truststoreType=");
                builder.append(_truststoreType);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
