package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-app-config</b>
 * <pre>
 * container pcep-session-config {
 *     leaf dead-timer-value {
 *         type dead-timer-value;
 *     }
 *     leaf keep-alive-timer-value {
 *         type keep-alive-timer-value;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-app-config/pcep-session-config</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfigBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfigBuilder
 *
 */
public interface PcepSessionConfig
    extends
    ChildOf<PcepAppConfigData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepSessionConfig>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:app-config",
        "2016-07-07", "pcep-session-config").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>deadTimerValue</code>, or <code>null</code> if not present
     */
    java.lang.Integer getDeadTimerValue();
    
    /**
     * @return <code>java.lang.Integer</code> <code>keepAliveTimerValue</code>, or <code>null</code> if not present
     */
    java.lang.Integer getKeepAliveTimerValue();

}

