package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;

public enum StoreType {
    JKS(0, "JKS"),
    
    PKCS12(1, "PKCS12")
    ;

    private static final java.util.Map<java.lang.Integer, StoreType> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, StoreType> b = com.google.common.collect.ImmutableMap.builder();
        for (StoreType enumItem : StoreType.values()) {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private final java.lang.String name;
    private final int value;

    private StoreType(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg integer value
     * @return corresponding StoreType item
     */
    public static StoreType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
