/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.pcep.PCEPCapability;
import org.opendaylight.protocol.pcep.PCEPPeerProposal;
import org.opendaylight.protocol.pcep.PCEPSessionProposalFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.TlvsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasePCEPSessionProposalFactory
implements PCEPSessionProposalFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BasePCEPSessionProposalFactory.class);
    private static final int KA_TO_DEADTIMER_RATIO = 4;
    private final int keepAlive;
    private final int deadTimer;
    private final List<PCEPCapability> capabilities;

    public BasePCEPSessionProposalFactory(int deadTimer, int keepAlive, List<PCEPCapability> capabilities) {
        if (keepAlive != 0) {
            Preconditions.checkArgument((keepAlive >= 1 ? 1 : 0) != 0, (Object)"Minimum value for keep-alive-timer-value is 1");
            if (deadTimer != 0 && deadTimer / keepAlive != 4) {
                LOG.warn("dead-timer-value should be {} times greater than keep-alive-timer-value", (Object)4);
            }
        }
        this.deadTimer = deadTimer;
        this.keepAlive = keepAlive;
        this.capabilities = Objects.requireNonNull(capabilities);
    }

    private void addTlvs(InetSocketAddress address, TlvsBuilder builder) {
        for (PCEPCapability capability : this.capabilities) {
            capability.setCapabilityProposal(address, builder);
        }
    }

    public Open getSessionProposal(InetSocketAddress address, int sessionId, PCEPPeerProposal peerProposal) {
        OpenBuilder oBuilder = new OpenBuilder();
        oBuilder.setSessionId(Short.valueOf((short)sessionId));
        oBuilder.setKeepalive(Short.valueOf((short)this.keepAlive));
        if (this.keepAlive == 0) {
            oBuilder.setDeadTimer(Short.valueOf((short)0));
        } else {
            oBuilder.setDeadTimer(Short.valueOf((short)this.deadTimer));
        }
        TlvsBuilder builder = new TlvsBuilder();
        this.addTlvs(address, builder);
        if (peerProposal != null) {
            peerProposal.setPeerSpecificProposal(address, builder);
        }
        return oBuilder.setTlvs(builder.build()).build();
    }

    public List<PCEPCapability> getCapabilities() {
        return this.capabilities;
    }
}

