/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandler;
import java.util.Objects;
import org.opendaylight.protocol.pcep.impl.PCEPByteToMessageDecoder;
import org.opendaylight.protocol.pcep.impl.PCEPMessageHeaderDecoder;
import org.opendaylight.protocol.pcep.impl.PCEPMessageToByteEncoder;
import org.opendaylight.protocol.pcep.spi.MessageRegistry;

public final class PCEPHandlerFactory {
    private final MessageRegistry registry;
    private final ChannelOutboundHandler encoder;

    public PCEPHandlerFactory(MessageRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
        this.encoder = new PCEPMessageToByteEncoder(registry);
    }

    public ChannelHandler[] getEncoders() {
        return new ChannelHandler[]{this.encoder};
    }

    public ChannelHandler[] getDecoders() {
        return new ChannelHandler[]{new PCEPMessageHeaderDecoder(), new PCEPByteToMessageDecoder(this.registry)};
    }
}

