/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PcepDispatcherConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepDispatcherConfigBuilder
implements Builder<PcepDispatcherConfig> {
    private Integer _maxUnknownMessages;
    private Tls _tls;
    Map<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> augmentation = Collections.emptyMap();

    public PcepDispatcherConfigBuilder() {
    }

    public PcepDispatcherConfigBuilder(PcepDispatcherConfig base) {
        AugmentationHolder casted;
        this._maxUnknownMessages = base.getMaxUnknownMessages();
        this._tls = base.getTls();
        if (base instanceof PcepDispatcherConfigImpl) {
            PcepDispatcherConfigImpl impl = (PcepDispatcherConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>>(casted.augmentations());
        }
    }

    public Integer getMaxUnknownMessages() {
        return this._maxUnknownMessages;
    }

    public Tls getTls() {
        return this._tls;
    }

    public <E extends Augmentation<PcepDispatcherConfig>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaxUnknownMessagesRange(int value) {
        if (value >= 1 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..65535]].", value));
    }

    public PcepDispatcherConfigBuilder setMaxUnknownMessages(Integer value) {
        if (value != null) {
            PcepDispatcherConfigBuilder.checkMaxUnknownMessagesRange(value);
        }
        this._maxUnknownMessages = value;
        return this;
    }

    public PcepDispatcherConfigBuilder setTls(Tls value) {
        this._tls = value;
        return this;
    }

    public PcepDispatcherConfigBuilder addAugmentation(Class<? extends Augmentation<PcepDispatcherConfig>> augmentationType, Augmentation<PcepDispatcherConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcepDispatcherConfigBuilder removeAugmentation(Class<? extends Augmentation<PcepDispatcherConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PcepDispatcherConfig build() {
        return new PcepDispatcherConfigImpl(this);
    }

    private static final class PcepDispatcherConfigImpl
    implements PcepDispatcherConfig {
        private final Integer _maxUnknownMessages;
        private final Tls _tls;
        private Map<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PcepDispatcherConfig> getImplementedInterface() {
            return PcepDispatcherConfig.class;
        }

        private PcepDispatcherConfigImpl(PcepDispatcherConfigBuilder base) {
            this._maxUnknownMessages = base.getMaxUnknownMessages();
            this._tls = base.getTls();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMaxUnknownMessages() {
            return this._maxUnknownMessages;
        }

        @Override
        public Tls getTls() {
            return this._tls;
        }

        public <E extends Augmentation<PcepDispatcherConfig>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxUnknownMessages);
            result = 31 * result + Objects.hashCode(this._tls);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepDispatcherConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepDispatcherConfig other = (PcepDispatcherConfig)obj;
            if (!Objects.equals(this._maxUnknownMessages, other.getMaxUnknownMessages())) {
                return false;
            }
            if (!Objects.equals(this._tls, other.getTls())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepDispatcherConfigImpl otherImpl = (PcepDispatcherConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcepDispatcherConfig>>, Augmentation<PcepDispatcherConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PcepDispatcherConfig [";
            StringBuilder builder = new StringBuilder(name);
            if (this._maxUnknownMessages != null) {
                builder.append("_maxUnknownMessages=");
                builder.append(this._maxUnknownMessages);
                builder.append(", ");
            }
            if (this._tls != null) {
                builder.append("_tls=");
                builder.append(this._tls);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

