/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum StoreType {
    JKS(0, "JKS"),
    PKCS12(1, "PKCS12");

    private static final Map<Integer, StoreType> VALUE_MAP;
    private final String name;
    private final int value;

    private StoreType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static StoreType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (StoreType enumItem : StoreType.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

