/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum NaiType implements Enumeration
{
    Ipv4NodeId(1, "ipv4-node-id"),
    Ipv6NodeId(2, "ipv6-node-id"),
    Ipv4Adjacency(3, "ipv4-adjacency"),
    Ipv6Adjacency(4, "ipv6-adjacency"),
    Unnumbered(5, "unnumbered"),
    Ipv6Local(6, "ipv6-local");

    private static final Map<String, NaiType> NAME_MAP;
    private static final Map<Integer, NaiType> VALUE_MAP;
    private final String name;
    private final int value;

    private NaiType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<NaiType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static NaiType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (NaiType enumItem : NaiType.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

