/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.segment.routing;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.NaiType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.SrSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.Nai;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpAdjacency;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpAdjacencyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpNodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.IpNodeIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.Ipv6Local;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.Ipv6LocalBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.UnnumberedAdjacency;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.nai.UnnumberedAdjacencyBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public abstract class AbstractSrSubobjectParser {
    protected static final int MINIMAL_LENGTH = 4;
    protected static final int BITSET_LENGTH = 8;
    protected static final int M_FLAG_POSITION = 7;
    protected static final int C_FLAG_POSITION = 6;
    protected static final int S_FLAG_POSITION = 5;
    protected static final int F_FLAG_POSITION = 4;
    protected static final int MPLS_LABEL_OFFSET = 12;
    private static final int NAI_TYPE_BITS_OFFSET = 4;

    public ByteBuf serializeSubobject(SrSubobject srSubobject) {
        Nai nai;
        Preconditions.checkArgument((srSubobject.getNai() != null || srSubobject.getSid() != null ? 1 : 0) != 0, (Object)"Both SID and NAI are absent in SR subobject.");
        ByteBuf buffer = Unpooled.buffer((int)4);
        buffer.writeByte(srSubobject.getNaiType().getIntValue() << 4);
        BitArray bits = new BitArray(8);
        bits.set(7, srSubobject.getMFlag());
        if (!srSubobject.getMFlag().booleanValue()) {
            bits.set(6, Boolean.FALSE);
        } else {
            bits.set(6, srSubobject.getCFlag());
        }
        if (srSubobject.getSid() == null) {
            bits.set(7, Boolean.FALSE);
            bits.set(6, Boolean.FALSE);
            bits.set(5, Boolean.TRUE);
        }
        if (srSubobject.getNai() == null || srSubobject.getNaiType().getIntValue() == 0) {
            bits.set(4, Boolean.TRUE);
        }
        bits.toByteBuf(buffer);
        if (srSubobject.getSid() != null) {
            if (srSubobject.getMFlag().booleanValue()) {
                buffer.writeInt(srSubobject.getSid().intValue() << 12);
            } else {
                ByteBufUtils.writeOrZero((ByteBuf)buffer, (Uint32)srSubobject.getSid());
            }
        }
        if ((nai = srSubobject.getNai()) != null) {
            AbstractSrSubobjectParser.serializeNai(nai, srSubobject.getNaiType(), buffer);
        }
        return buffer;
    }

    private static void serializeNai(Nai nai, NaiType naiType, ByteBuf buffer) {
        switch (naiType) {
            case Ipv4NodeId: {
                Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)((IpNodeId)nai).getIpAddress().getIpv4AddressNoZone(), (ByteBuf)buffer);
                break;
            }
            case Ipv6NodeId: {
                Ipv6Util.writeIpv6Address((Ipv6AddressNoZone)((IpNodeId)nai).getIpAddress().getIpv6AddressNoZone(), (ByteBuf)buffer);
                break;
            }
            case Ipv4Adjacency: {
                Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)((IpAdjacency)nai).getLocalIpAddress().getIpv4AddressNoZone(), (ByteBuf)buffer);
                Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)((IpAdjacency)nai).getRemoteIpAddress().getIpv4AddressNoZone(), (ByteBuf)buffer);
                break;
            }
            case Ipv6Adjacency: {
                Ipv6Util.writeIpv6Address((Ipv6AddressNoZone)((IpAdjacency)nai).getLocalIpAddress().getIpv6AddressNoZone(), (ByteBuf)buffer);
                Ipv6Util.writeIpv6Address((Ipv6AddressNoZone)((IpAdjacency)nai).getRemoteIpAddress().getIpv6AddressNoZone(), (ByteBuf)buffer);
                break;
            }
            case Unnumbered: {
                UnnumberedAdjacency unnumbered = (UnnumberedAdjacency)nai;
                ByteBufUtils.writeOrZero((ByteBuf)buffer, (Uint32)unnumbered.getLocalNodeId());
                ByteBufUtils.writeOrZero((ByteBuf)buffer, (Uint32)unnumbered.getLocalInterfaceId());
                ByteBufUtils.writeOrZero((ByteBuf)buffer, (Uint32)unnumbered.getRemoteNodeId());
                ByteBufUtils.writeOrZero((ByteBuf)buffer, (Uint32)unnumbered.getRemoteInterfaceId());
                break;
            }
            case Ipv6Local: {
                Ipv6Local ipv6Local = (Ipv6Local)nai;
                Ipv6Util.writeIpv6Address((Ipv6AddressNoZone)ipv6Local.getLocalIpv6Address(), (ByteBuf)buffer);
                ByteBufUtils.writeOrZero((ByteBuf)buffer, (Uint32)ipv6Local.getLocalId());
                Ipv6Util.writeIpv6Address((Ipv6AddressNoZone)ipv6Local.getRemoteIpv6Address(), (ByteBuf)buffer);
                ByteBufUtils.writeOrZero((ByteBuf)buffer, (Uint32)ipv6Local.getRemoteId());
                break;
            }
        }
    }

    private static Nai parseNai(NaiType naiType, ByteBuf buffer) {
        switch (naiType) {
            case Ipv4NodeId: {
                return new IpNodeIdBuilder().setIpAddress(new IpAddressNoZone(Ipv4Util.addressForByteBuf((ByteBuf)buffer))).build();
            }
            case Ipv6NodeId: {
                return new IpNodeIdBuilder().setIpAddress(new IpAddressNoZone(Ipv6Util.addressForByteBuf((ByteBuf)buffer))).build();
            }
            case Ipv4Adjacency: {
                return new IpAdjacencyBuilder().setLocalIpAddress(new IpAddressNoZone(Ipv4Util.addressForByteBuf((ByteBuf)buffer))).setRemoteIpAddress(new IpAddressNoZone(Ipv4Util.addressForByteBuf((ByteBuf)buffer))).build();
            }
            case Ipv6Adjacency: {
                return new IpAdjacencyBuilder().setLocalIpAddress(new IpAddressNoZone(Ipv6Util.addressForByteBuf((ByteBuf)buffer))).setRemoteIpAddress(new IpAddressNoZone(Ipv6Util.addressForByteBuf((ByteBuf)buffer))).build();
            }
            case Unnumbered: {
                return new UnnumberedAdjacencyBuilder().setLocalNodeId(ByteBufUtils.readUint32((ByteBuf)buffer)).setLocalInterfaceId(ByteBufUtils.readUint32((ByteBuf)buffer)).setRemoteNodeId(ByteBufUtils.readUint32((ByteBuf)buffer)).setRemoteInterfaceId(ByteBufUtils.readUint32((ByteBuf)buffer)).build();
            }
            case Ipv6Local: {
                return new Ipv6LocalBuilder().setLocalIpv6Address(Ipv6Util.addressForByteBuf((ByteBuf)buffer)).setLocalId(ByteBufUtils.readUint32((ByteBuf)buffer)).setRemoteIpv6Address(Ipv6Util.addressForByteBuf((ByteBuf)buffer)).setRemoteId(ByteBufUtils.readUint32((ByteBuf)buffer)).build();
            }
        }
        return null;
    }

    protected static SrSubobject parseSrSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Uint32 sid;
        int naiTypeByte = buffer.readByte() >> 4;
        NaiType naiType = NaiType.forValue(naiTypeByte);
        BitArray bitSet = BitArray.valueOf((byte)buffer.readByte());
        boolean f = bitSet.get(4);
        boolean s = bitSet.get(5);
        boolean c = bitSet.get(6);
        boolean m = bitSet.get(7);
        if (f && s) {
            throw new PCEPDeserializerException("Both SID and NAI are absent in SR subobject.");
        }
        if (!s) {
            long tmp = buffer.readUnsignedInt();
            sid = Uint32.valueOf((long)(m ? tmp >> 12 : tmp));
        } else {
            sid = null;
        }
        Nai nai = naiType != null && naiType.getIntValue() != 0 && !f ? AbstractSrSubobjectParser.parseNai(naiType, buffer) : null;
        return new SrSubobjectImpl(m, c, naiType, sid, nai);
    }

    private static class SrSubobjectImpl
    implements SrSubobject {
        private final boolean mflag;
        private final boolean cflag;
        private final NaiType naiType;
        private final Uint32 sid;
        private final Nai nai;

        SrSubobjectImpl(boolean mflag, boolean cflag, NaiType naiType, Uint32 sid, Nai nai) {
            this.mflag = mflag;
            this.cflag = cflag;
            this.naiType = naiType;
            this.sid = sid;
            this.nai = nai;
        }

        public Class<SrSubobject> implementedInterface() {
            return SrSubobject.class;
        }

        @Override
        public Boolean getMFlag() {
            return this.mflag;
        }

        @Override
        public Boolean getCFlag() {
            return this.cflag;
        }

        @Override
        public NaiType getNaiType() {
            return this.naiType;
        }

        @Override
        public Uint32 getSid() {
            return this.sid;
        }

        @Override
        public Nai getNai() {
            return this.nai;
        }
    }
}

