/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.segment.routing;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.SrPceCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.SrPceCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class SrPceCapabilityTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 26;
    private static final int BITSET_LENGTH = 8;
    private static final int N_FLAG_POSITION = 7;
    private static final int X_FLAG_POSITION = 6;
    private static final int CONTENT_LENGTH = 4;
    private static final int OFFSET = 2;

    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(tlv instanceof SrPceCapability), (Object)"SrPceCapability is mandatory.");
        ByteBuf body = Unpooled.buffer((int)4);
        body.writerIndex(2);
        SrPceCapability srPceCapability = (SrPceCapability)tlv;
        BitArray bits = new BitArray(8);
        bits.set(7, srPceCapability.getNFlag());
        bits.set(6, srPceCapability.getXFlag());
        bits.toByteBuf(body);
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)srPceCapability.getMsd());
        TlvUtil.formatTlv((int)26, (ByteBuf)body, (ByteBuf)buffer);
    }

    public Tlv parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        BitArray bitSet = BitArray.valueOf((byte)buffer.readerIndex(2).readByte());
        boolean n = bitSet.get(7);
        boolean x = bitSet.get(6);
        return new SrPceCapabilityBuilder().setNFlag(n).setXFlag(x).setMsd(ByteBufUtils.readUint8((ByteBuf)buffer)).build();
    }
}

