/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.segment.routing;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.segment.routing.AbstractSrSubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.SrSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.add.lsp.input.arguments.rro.subobject.subobject.type.SrRroTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType;

public class SrRroSubobjectParser
extends AbstractSrSubobjectParser
implements RROSubobjectParser,
RROSubobjectSerializer {
    @Deprecated
    private static final int LEGACY_TYPE = 6;
    private static final int IANA_TYPE = 36;
    @Deprecated
    private final int type;

    SrRroSubobjectParser() {
        this.type = 36;
    }

    @Deprecated
    SrRroSubobjectParser(boolean isIanaAssignedType) {
        this.type = isIanaAssignedType ? 36 : 6;
    }

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        SubobjectType subobjType = subobject.getSubobjectType();
        Preconditions.checkArgument((boolean)(subobjType instanceof SrSubobject), (String)"Unknown subobject instance. Passed %s. Needed SrSubobject.", subobjType.getClass());
        SrSubobject srSubobject = (SrSubobject)subobjType;
        ByteBuf body = this.serializeSubobject(srSubobject);
        RROSubobjectUtil.formatSubobject((int)this.type, (ByteBuf)body, (ByteBuf)buffer);
    }

    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        SrRroTypeBuilder srRroSubobjectBuilder = new SrRroTypeBuilder(SrRroSubobjectParser.parseSrSubobject(buffer));
        SubobjectBuilder subobjectBuilder = new SubobjectBuilder();
        subobjectBuilder.setSubobjectType((SubobjectType)srRroSubobjectBuilder.build());
        return subobjectBuilder.build();
    }

    @Deprecated
    public int getCodePoint() {
        return this.type;
    }
}

