package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-pcep-segment-routing</b>
 * <pre>
 * typedef nai-type {
 *   type enumeration {
 *     enum ipv4-node-id {
 *       value 1;
 *     }
 *     enum ipv6-node-id {
 *       value 2;
 *     }
 *     enum ipv4-adjacency {
 *       value 3;
 *     }
 *     enum ipv6-adjacency {
 *       value 4;
 *     }
 *     enum unnumbered {
 *       value 5;
 *     }
 *     enum ipv6-local {
 *       value 6;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum NaiType implements EnumTypeObject {
    Ipv4NodeId(1, "ipv4-node-id"),
    
    Ipv6NodeId(2, "ipv6-node-id"),
    
    Ipv4Adjacency(3, "ipv4-adjacency"),
    
    Ipv6Adjacency(4, "ipv6-adjacency"),
    
    Unnumbered(5, "unnumbered"),
    
    Ipv6Local(6, "ipv6-local")
    ;

    private final @NonNull String name;
    private final int value;

    private NaiType(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding NaiType item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable NaiType forName(String name) {
        return switch (name) {
            case "ipv4-node-id" -> Ipv4NodeId;
            case "ipv6-node-id" -> Ipv6NodeId;
            case "ipv4-adjacency" -> Ipv4Adjacency;
            case "ipv6-adjacency" -> Ipv6Adjacency;
            case "unnumbered" -> Unnumbered;
            case "ipv6-local" -> Ipv6Local;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding NaiType item, or {@code null} if no such item exists
     */
    public static @Nullable NaiType forValue(int intValue) {
        return switch (intValue) {
            case 1 -> Ipv4NodeId;
            case 2 -> Ipv6NodeId;
            case 3 -> Ipv4Adjacency;
            case 4 -> Ipv6Adjacency;
            case 5 -> Unnumbered;
            case 6 -> Ipv6Local;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding NaiType item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull NaiType ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding NaiType item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull NaiType ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
