package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the data model of PCEP Extensions for Segment Routing, as 
 * defined in RFC 8664. Copyright (c)2015 Cisco Systems, Inc. All rights reserved. 
 * This program and the accompanying materials are made available under the terms 
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-pcep-segment-routing</b>
 * <pre>
 * module odl-pcep-segment-routing {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:pcep:segment:routing;
 *   prefix pcep-sr;
 *   import pcep-types {
 *     prefix pcep;
 *     revision-date 2018-11-09;
 *   }
 *   import pcep-message {
 *     prefix msg;
 *     revision-date 2018-11-09;
 *   }
 *   import odl-pcep-ietf-stateful {
 *     prefix stateful;
 *     revision-date 2020-07-20;
 *   }
 *   import odl-pcep-ietf-initiated {
 *     prefix initiated;
 *     revision-date 2020-07-20;
 *   }
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import network-topology {
 *     prefix nt;
 *     revision-date 2013-10-21;
 *   }
 *   import network-topology-pcep {
 *     prefix pn;
 *     revision-date 2022-07-30;
 *   }
 *   revision 2020-07-20 {
 *   }
 *   revision 2018-11-09 {
 *   }
 *   revision 2017-10-25 {
 *   }
 *   revision 2015-01-12 {
 *   }
 *   grouping sr-pce-capability-tlv {
 *     container sr-pce-capability {
 *       uses pcep:tlv;
 *       leaf n-flag {
 *         type boolean;
 *         default false;
 *       }
 *       leaf x-flag {
 *         type boolean;
 *         default false;
 *       }
 *       leaf msd {
 *         type uint8;
 *         default 0;
 *       }
 *     }
 *   }
 *   augment /msg:open/msg:open-message/msg:open/msg:tlvs {
 *     uses sr-pce-capability-tlv;
 *   }
 *   augment /msg:pcerr/msg:pcerr-message/msg:error-type/msg:session-case/msg:session/msg:open/msg:tlvs {
 *     uses sr-pce-capability-tlv;
 *   }
 *   typedef nai-type {
 *     type enumeration {
 *       enum ipv4-node-id {
 *         value 1;
 *       }
 *       enum ipv6-node-id {
 *         value 2;
 *       }
 *       enum ipv4-adjacency {
 *         value 3;
 *       }
 *       enum ipv6-adjacency {
 *         value 4;
 *       }
 *       enum unnumbered {
 *         value 5;
 *       }
 *       enum ipv6-local {
 *         value 6;
 *       }
 *     }
 *   }
 *   grouping sr-subobject {
 *     leaf nai-type {
 *       type nai-type;
 *     }
 *     leaf m-flag {
 *       type boolean;
 *       default false;
 *     }
 *     leaf c-flag {
 *       type boolean;
 *       default false;
 *     }
 *     leaf sid {
 *       type uint32;
 *     }
 *     choice nai {
 *       case ip-node-id {
 *         when "../nai-type = 'ipv4-node-id' or ../nai-type = 'ipv6-node-id'";
 *         leaf ip-address {
 *           type inet:ip-address-no-zone;
 *         }
 *       }
 *       case ip-adjacency {
 *         when "../nai-type = 'ipv4-adjacency' or ../nai-type = 'ipv6-adjacency'";
 *         leaf local-ip-address {
 *           type inet:ip-address-no-zone;
 *         }
 *         leaf remote-ip-address {
 *           type inet:ip-address-no-zone;
 *         }
 *       }
 *       case unnumbered-adjacency {
 *         when "../nai-type = 'unnumbered'";
 *         leaf local-node-id {
 *           type uint32;
 *         }
 *         leaf local-interface-id {
 *           type uint32;
 *         }
 *         leaf remote-node-id {
 *           type uint32;
 *         }
 *         leaf remote-interface-id {
 *           type uint32;
 *         }
 *       }
 *       case ipv6-local {
 *         when "../nai-type = 'ipv6-local'";
 *         leaf local-ipv6-address {
 *           type inet:ipv6-address-no-zone;
 *         }
 *         leaf local-id {
 *           type uint32;
 *         }
 *         leaf remote-ipv6-address {
 *           type inet:ipv6-address-no-zone;
 *         }
 *         leaf remote-id {
 *           type uint32;
 *         }
 *       }
 *     }
 *   }
 *   grouping sr-ero-subobject {
 *     uses sr-subobject;
 *   }
 *   grouping sr-rro-subobject {
 *     uses sr-subobject;
 *   }
 *   augment /msg:pcrep/msg:pcrep-message/msg:replies/msg:result/msg:success-case/msg:success/msg:paths/msg:ero/msg:subobject/msg:subobject-type {
 *     case sr-ero-type {
 *       uses sr-ero-subobject;
 *     }
 *   }
 *   augment /initiated:pcinitiate/initiated:pcinitiate-message/initiated:requests/initiated:ero/initiated:subobject/initiated:subobject-type {
 *     case sr-ero-type {
 *       uses sr-ero-subobject;
 *     }
 *   }
 *   augment /stateful:pcrpt/stateful:pcrpt-message/stateful:reports/stateful:path/stateful:ero/stateful:subobject/stateful:subobject-type {
 *     case sr-ero-type {
 *       uses sr-ero-subobject;
 *     }
 *   }
 *   augment /stateful:pcupd/stateful:pcupd-message/stateful:updates/stateful:path/stateful:ero/stateful:subobject/stateful:subobject-type {
 *     case sr-ero-type {
 *       uses sr-ero-subobject;
 *     }
 *   }
 *   augment /pn:add-lsp/pn:input/pn:arguments/pn:ero/pn:subobject/pn:subobject-type {
 *     case sr-ero-type {
 *       uses sr-ero-subobject;
 *     }
 *   }
 *   augment /pn:update-lsp/pn:input/pn:arguments/pn:ero/pn:subobject/pn:subobject-type {
 *     case sr-ero-type {
 *       uses sr-ero-subobject;
 *     }
 *   }
 *   augment /nt:network-topology/nt:topology/nt:node/pn:path-computation-client/pn:reported-lsp/pn:path/pn:ero/pn:subobject/pn:subobject-type {
 *     case sr-ero-type {
 *       uses sr-ero-subobject;
 *     }
 *   }
 *   augment /msg:pcreq/msg:pcreq-message/msg:requests/msg:segment-computation/msg:p2p/msg:reported-route/msg:rro/msg:subobject/msg:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 *   augment /msg:pcreq/msg:pcreq-message/msg:requests/msg:segment-computation/msg:p2p/msg:rro/msg:subobject/msg:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 *   augment /msg:pcrep/msg:pcrep-message/msg:replies/msg:result/msg:failure-case/msg:rro/msg:subobject/msg:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 *   augment /msg:pcrep/msg:pcrep-message/msg:replies/msg:result/msg:success-case/msg:success/msg:paths/msg:rro/msg:subobject/msg:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 *   augment /initiated:pcinitiate/initiated:pcinitiate-message/initiated:requests/initiated:rro/initiated:subobject/initiated:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 *   augment /stateful:pcrpt/stateful:pcrpt-message/stateful:reports/stateful:path/stateful:rro/stateful:subobject/stateful:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 *   augment /stateful:pcupd/stateful:pcupd-message/stateful:updates/stateful:path/stateful:rro/stateful:subobject/stateful:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 *   augment /pn:add-lsp/pn:input/pn:arguments/pn:rro/pn:subobject/pn:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 *   augment /pn:update-lsp/pn:input/pn:arguments/pn:rro/pn:subobject/pn:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 *   augment /nt:network-topology/nt:topology/nt:node/pn:path-computation-client/pn:reported-lsp/pn:path/pn:rro/pn:subobject/pn:subobject-type {
 *     case sr-rro-type {
 *       uses sr-rro-subobject;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OdlPcepSegmentRoutingData
    extends
    DataRoot
{





}

