package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.Nai;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Common grouping for both SR-ERO and SR-RRO subobjects as they share the same 
 * content representation.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-pcep-segment-routing</b>
 * <pre>
 * grouping sr-subobject {
 *   leaf nai-type {
 *     type nai-type;
 *   }
 *   leaf m-flag {
 *     type boolean;
 *     default false;
 *   }
 *   leaf c-flag {
 *     type boolean;
 *     default false;
 *   }
 *   leaf sid {
 *     type uint32;
 *   }
 *   choice nai {
 *     case ip-node-id {
 *       when "../nai-type = 'ipv4-node-id' or ../nai-type = 'ipv6-node-id'";
 *       leaf ip-address {
 *         type inet:ip-address-no-zone;
 *       }
 *     }
 *     case ip-adjacency {
 *       when "../nai-type = 'ipv4-adjacency' or ../nai-type = 'ipv6-adjacency'";
 *       leaf local-ip-address {
 *         type inet:ip-address-no-zone;
 *       }
 *       leaf remote-ip-address {
 *         type inet:ip-address-no-zone;
 *       }
 *     }
 *     case unnumbered-adjacency {
 *       when "../nai-type = 'unnumbered'";
 *       leaf local-node-id {
 *         type uint32;
 *       }
 *       leaf local-interface-id {
 *         type uint32;
 *       }
 *       leaf remote-node-id {
 *         type uint32;
 *       }
 *       leaf remote-interface-id {
 *         type uint32;
 *       }
 *     }
 *     case ipv6-local {
 *       when "../nai-type = 'ipv6-local'";
 *       leaf local-ipv6-address {
 *         type inet:ipv6-address-no-zone;
 *       }
 *       leaf local-id {
 *         type uint32;
 *       }
 *       leaf remote-ipv6-address {
 *         type inet:ipv6-address-no-zone;
 *       }
 *       leaf remote-id {
 *         type uint32;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SrSubobject
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("sr-subobject");

    @Override
    Class<? extends SrSubobject> implementedInterface();
    
    /**
     * Return naiType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Node or Adjacency Identifier Type (NT)
     *     </code>
     * </pre>
     *
     * @return {@code NaiType} naiType, or {@code null} if it is not present.
     *
     */
    NaiType getNaiType();
    
    /**
     * Return naiType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Node or Adjacency Identifier Type (NT)
     *     </code>
     * </pre>
     *
     * @return {@code NaiType} naiType, guaranteed to be non-null.
     * @throws NoSuchElementException if naiType is not present
     *
     */
    default @NonNull NaiType requireNaiType() {
        return CodeHelpers.require(getNaiType(), "naitype");
    }
    
    /**
     * Return mFlag, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         If this bit is set to 1, the SID value represents an MPLS label stack entry
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} mFlag, or {@code null} if it is not present.
     *
     */
    Boolean getMFlag();
    
    /**
     * Return mFlag, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         If this bit is set to 1, the SID value represents an MPLS label stack entry
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} mFlag, guaranteed to be non-null.
     * @throws NoSuchElementException if mFlag is not present
     *
     */
    default @NonNull Boolean requireMFlag() {
        return CodeHelpers.require(getMFlag(), "mflag");
    }
    
    /**
     * Return cFlag, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         TC, S &amp; TTL fields in the MPLS label are specified by the PCE if M &amp; C
     *         are set to 1
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} cFlag, or {@code null} if it is not present.
     *
     */
    Boolean getCFlag();
    
    /**
     * Return cFlag, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         TC, S &amp; TTL fields in the MPLS label are specified by the PCE if M &amp; C
     *         are set to 1
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} cFlag, guaranteed to be non-null.
     * @throws NoSuchElementException if cFlag is not present
     *
     */
    default @NonNull Boolean requireCFlag() {
        return CodeHelpers.require(getCFlag(), "cflag");
    }
    
    /**
     * Return sid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Segment Identifier
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} sid, or {@code null} if it is not present.
     *
     */
    Uint32 getSid();
    
    /**
     * Return sid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Segment Identifier
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} sid, guaranteed to be non-null.
     * @throws NoSuchElementException if sid is not present
     *
     */
    default @NonNull Uint32 requireSid() {
        return CodeHelpers.require(getSid(), "sid");
    }
    
    /**
     * Return nai, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Node or Adjacency Identifier
     *     </code>
     * </pre>
     *
     * @return {@code Nai} nai, or {@code null} if it is not present.
     *
     */
    Nai getNai();

}

