package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.SrPceCapability;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Tlvs2} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Tlvs2 createTlvs2(int fooXyzzy, int barBaz) {
 *         return new Tlvs2Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Tlvs2, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Tlvs2
 *
 */
@Generated("mdsal-binding-generator")
public class Tlvs2Builder {

    private SrPceCapability _srPceCapability;



    /**
     * Construct an empty builder.
     */
    public Tlvs2Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link SrPceCapabilityTlv}.
     *
     * @param arg SrPceCapabilityTlv from which the builder should be initialized
     */
    public Tlvs2Builder(SrPceCapabilityTlv arg) {
        this._srPceCapability = arg.getSrPceCapability();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Tlvs2}.
     *
     * @param base Tlvs2 from which the builder should be initialized
     */
    public Tlvs2Builder(Tlvs2 base) {
        this._srPceCapability = base.getSrPceCapability();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SrPceCapabilityTlv}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrPceCapabilityTlv castArg) {
            this._srPceCapability = castArg.getSrPceCapability();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SrPceCapabilityTlv]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Tlvs2#getSrPceCapability()}.
     *
     * @return current value
     */
    public SrPceCapability getSrPceCapability() {
        return _srPceCapability;
    }

    
    /**
     * Set the property corresponding to {@link Tlvs2#getSrPceCapability()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Tlvs2Builder setSrPceCapability(final SrPceCapability value) {
        this._srPceCapability = value;
        return this;
    }
    

    /**
     * A new {@link Tlvs2} instance.
     *
     * @return A new {@link Tlvs2} instance.
     */
    public @NonNull Tlvs2 build() {
        return new Tlvs2Impl(this);
    }

    private static final class Tlvs2Impl
        implements Tlvs2 {
    
        private final SrPceCapability _srPceCapability;
    
        Tlvs2Impl(Tlvs2Builder base) {
            this._srPceCapability = base.getSrPceCapability();
        }
    
        @Override
        public SrPceCapability getSrPceCapability() {
            return _srPceCapability;
        }
    
        @Override
        public SrPceCapability nonnullSrPceCapability() {
            return Objects.requireNonNullElse(getSrPceCapability(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.SrPceCapabilityBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Tlvs2.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Tlvs2.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Tlvs2.bindingToString(this);
        }
    }
}
