package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.pcrep.pcrep.message.replies.result.success._case.success.paths.rro.subobject.subobject.type;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.NaiType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.SrRroSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.SrSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.subobject.Nai;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link SrRroType} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SrRroType createSrRroType(int fooXyzzy, int barBaz) {
 *         return new SrRroTypeBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SrRroType, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SrRroType
 *
 */
@Generated("mdsal-binding-generator")
public class SrRroTypeBuilder {

    private Boolean _cFlag;
    private Boolean _mFlag;
    private Nai _nai;
    private NaiType _naiType;
    private Uint32 _sid;


    Map<Class<? extends Augmentation<SrRroType>>, Augmentation<SrRroType>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SrRroTypeBuilder() {
        // No-op
    }

    
    
    
    /**
     * Construct a new builder initialized from specified {@link SrRroSubobject}.
     *
     * @param arg SrRroSubobject from which the builder should be initialized
     */
    public SrRroTypeBuilder(SrRroSubobject arg) {
        this._naiType = arg.getNaiType();
        this._mFlag = arg.getMFlag();
        this._cFlag = arg.getCFlag();
        this._sid = arg.getSid();
        this._nai = arg.getNai();
    }
    
    /**
     * Construct a new builder initialized from specified {@link SrSubobject}.
     *
     * @param arg SrSubobject from which the builder should be initialized
     */
    public SrRroTypeBuilder(SrSubobject arg) {
        this._naiType = arg.getNaiType();
        this._mFlag = arg.getMFlag();
        this._cFlag = arg.getCFlag();
        this._sid = arg.getSid();
        this._nai = arg.getNai();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link SrRroType}.
     *
     * @param base SrRroType from which the builder should be initialized
     */
    public SrRroTypeBuilder(SrRroType base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._cFlag = base.getCFlag();
        this._mFlag = base.getMFlag();
        this._nai = base.getNai();
        this._naiType = base.getNaiType();
        this._sid = base.getSid();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SrRroSubobject}</li>
     *   <li>{@link SrSubobject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrRroSubobject castArg) {
            isValidArg = true;
        }
        if (arg instanceof SrSubobject castArg) {
            this._naiType = castArg.getNaiType();
            this._mFlag = castArg.getMFlag();
            this._cFlag = castArg.getCFlag();
            this._sid = castArg.getSid();
            this._nai = castArg.getNai();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SrRroSubobject, SrSubobject]");
    }


    /**
     * Return current value associated with the property corresponding to {@link SrRroType#getCFlag()}.
     *
     * @return current value
     */
    public Boolean getCFlag() {
        return _cFlag;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SrRroType#getMFlag()}.
     *
     * @return current value
     */
    public Boolean getMFlag() {
        return _mFlag;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SrRroType#getNai()}.
     *
     * @return current value
     */
    public Nai getNai() {
        return _nai;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SrRroType#getNaiType()}.
     *
     * @return current value
     */
    public NaiType getNaiType() {
        return _naiType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link SrRroType#getSid()}.
     *
     * @return current value
     */
    public Uint32 getSid() {
        return _sid;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrRroType>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link SrRroType#getCFlag()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SrRroTypeBuilder setCFlag(final Boolean value) {
        this._cFlag = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SrRroType#getMFlag()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SrRroTypeBuilder setMFlag(final Boolean value) {
        this._mFlag = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SrRroType#getNai()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SrRroTypeBuilder setNai(final Nai value) {
        this._nai = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SrRroType#getNaiType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SrRroTypeBuilder setNaiType(final NaiType value) {
        this._naiType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link SrRroType#getSid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SrRroTypeBuilder setSid(final Uint32 value) {
        this._sid = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrRroTypeBuilder addAugmentation(Augmentation<SrRroType> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrRroTypeBuilder removeAugmentation(Class<? extends Augmentation<SrRroType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link SrRroType} instance.
     *
     * @return A new {@link SrRroType} instance.
     */
    public @NonNull SrRroType build() {
        return new SrRroTypeImpl(this);
    }

    private static final class SrRroTypeImpl
        extends AbstractAugmentable<SrRroType>
        implements SrRroType {
    
        private final Boolean _cFlag;
        private final Boolean _mFlag;
        private final Nai _nai;
        private final NaiType _naiType;
        private final Uint32 _sid;
    
        SrRroTypeImpl(SrRroTypeBuilder base) {
            super(base.augmentation);
            this._cFlag = base.getCFlag();
            this._mFlag = base.getMFlag();
            this._nai = base.getNai();
            this._naiType = base.getNaiType();
            this._sid = base.getSid();
        }
    
        @Override
        public Boolean getCFlag() {
            return _cFlag;
        }
        
        @Override
        public Boolean getMFlag() {
            return _mFlag;
        }
        
        @Override
        public Nai getNai() {
            return _nai;
        }
        
        @Override
        public NaiType getNaiType() {
            return _naiType;
        }
        
        @Override
        public Uint32 getSid() {
            return _sid;
        }
    
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SrRroType.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SrRroType.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SrRroType.bindingToString(this);
        }
    }
}
