package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.SrPceCapabilityTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-pcep-segment-routing</b>
 * <pre>
 * container sr-pce-capability {
 *   uses pcep:tlv;
 *   leaf n-flag {
 *     type boolean;
 *     default false;
 *   }
 *   leaf x-flag {
 *     type boolean;
 *     default false;
 *   }
 *   leaf msd {
 *     type uint8;
 *     default 0;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link SrPceCapabilityBuilder}.
 * @see SrPceCapabilityBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface SrPceCapability
    extends
    ChildOf<SrPceCapabilityTlv>,
    Augmentable<SrPceCapability>,
    Tlv
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("sr-pce-capability");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.SrPceCapability> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.SrPceCapability.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.@NonNull SrPceCapability obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getMsd());
        result = prime * result + Objects.hashCode(obj.getNFlag());
        result = prime * result + Objects.hashCode(obj.getXFlag());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.@NonNull SrPceCapability thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.SrPceCapability.class, obj);
        return other != null
            && Objects.equals(thisObj.getMsd(), other.getMsd())
            && Objects.equals(thisObj.getNFlag(), other.getNFlag())
            && Objects.equals(thisObj.getXFlag(), other.getXFlag())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.segment.routing.rev200720.sr.pce.capability.tlv.@NonNull SrPceCapability obj) {
        final var helper = MoreObjects.toStringHelper("SrPceCapability");
        CodeHelpers.appendValue(helper, "msd", obj.getMsd());
        CodeHelpers.appendValue(helper, "nFlag", obj.getNFlag());
        CodeHelpers.appendValue(helper, "xFlag", obj.getXFlag());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return nFlag, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         N flag used by a PCC to indicate that it is capable of resolving a NAI to a SID
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} nFlag, or {@code null} if it is not present.
     *
     */
    Boolean getNFlag();
    
    /**
     * Return nFlag, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         N flag used by a PCC to indicate that it is capable of resolving a NAI to a SID
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} nFlag, guaranteed to be non-null.
     * @throws NoSuchElementException if nFlag is not present
     *
     */
    default @NonNull Boolean requireNFlag() {
        return CodeHelpers.require(getNFlag(), "nflag");
    }
    
    /**
     * Return xFlag, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *          X flag used by a PCC to indicate that it does not impose any limit to the MSD
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} xFlag, or {@code null} if it is not present.
     *
     */
    Boolean getXFlag();
    
    /**
     * Return xFlag, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *          X flag used by a PCC to indicate that it does not impose any limit to the MSD
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} xFlag, guaranteed to be non-null.
     * @throws NoSuchElementException if xFlag is not present
     *
     */
    default @NonNull Boolean requireXFlag() {
        return CodeHelpers.require(getXFlag(), "xflag");
    }
    
    /**
     * Return msd, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Maximum SID Depth
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} msd, or {@code null} if it is not present.
     *
     */
    Uint8 getMsd();
    
    /**
     * Return msd, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Maximum SID Depth
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} msd, guaranteed to be non-null.
     * @throws NoSuchElementException if msd is not present
     *
     */
    default @NonNull Uint8 requireMsd() {
        return CodeHelpers.require(getMsd(), "msd");
    }

}

